/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using PilotRocketChatGateway.Authentication;
using PilotRocketChatGateway.PilotServer;
using PilotRocketChatGateway.UserContext;

namespace PilotRocketChatGateway.Controllers
{
    [ApiController]
    public class UndefinedController : ControllerBase
    {
        private IContextsBank _contextsBank;
        private IAuthHelper _authHelper;

        public UndefinedController(IContextsBank contextsBank, IAuthHelper authHelper)
        {
            _contextsBank = contextsBank;
            _authHelper = authHelper;
        }

        [Authorize]
        [HttpGet("api/v1/undefined.members")]
        public string Members(string roomId, int offset, int count)
        {
            var context = _contextsBank.GetContext(HttpContext.GetTokenActor(_authHelper));
            var (users, total) = context.ChatService.DataLoader.LoadMembers(roomId, count, offset, string.Empty);
            var result = new { success = true, members = users, total = total, count = count, offset = offset };
            return JsonConvert.SerializeObject(result);
        }
    }
}
