/*
  Copyright © 2018 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Ascon.Pilot.Server.Api.Contracts;
using PilotShare.Core;

namespace PilotShare.Server.Models
{
    public interface ILinkStateProvider
    {
        Task<State> GetStateLinkAsync(Guid linkId);
        Task<LinkDefinition> GetLinkDefinitionAsync(Guid linkId);
    }

    class LinkStateProvider : ILinkStateProvider
    {
        private readonly IServerApi _serverApi;

        public LinkStateProvider(IServerApi serverApi)
        {
            _serverApi = serverApi ?? throw new ArgumentNullException(nameof(serverApi));
        }

        public async Task<State> GetStateLinkAsync(Guid linkId)
        {
            var definition = await GetLinkDefinitionAsync(linkId);
            return CreateState(definition, linkId);
        }

        public Task<LinkDefinition> GetLinkDefinitionAsync(Guid linkId)
        {
            var task = new LinkTask(linkId, _serverApi);
            return task.LoadDefinitionAsync();
        }

        private State CreateState(LinkDefinition link, Guid linkId)
        {
            var state = new State
            {
                Id = linkId,
                FileName = link.Item.Name,
                FileSize = link.FileSize(),
                SharedBy = link.SharedBy,
            };
            if (link.ValidThrough.HasValue && link.ValidThrough.Value < DateTime.UtcNow)
            {
                state.ErrorMessage = "Link expired"; //TODO Localization
            }
            if (!string.IsNullOrEmpty(link.Password))
            {
                state.NeedPassword = true;
            }

            return state;
        }
    }
}
