# Pilot-Web-SDK
 
**Pilot-Web-SDK** предназначен для создания frontend и backend модулей расширений к **Pilot-Web-Server**.

## Содержание

### Описание настройки сборки расширений
- [Общая информация](#Recomendation)
- [Настройка и запуск проекта frontend-расширения](#FrontendExtSetup)
  - [TypeScript расширение](#TypeScriptExtSettings)
    - [Настройка TS-расширения](#TypeScriptSetUp)
    - [Запуск TS-расширения](#TypeScriptRun)
      - [Debug](#TypeScriptRunDebug)
      - [Production](#TypeScriptRunProduction)
  - [Angular расширение](#AngularExtSettings)
    - [Настройка Angular-расширения](#AngularSetUp)
    - [Встраивание Angular в UI](#AngularOpenspaceView)
    - [Запуск Angular-расширения](#AngularRun)
      - [Debug](#AngularRunDebug)
      - [Production](#AngularRunProduction)
  - [React расширение](#ReactExtSettings)
    - [Настройка React-расширения](#ReactSetUp)
    - [Встраивание React в UI](#ReactOpenspaceView)
    - [Запуск React-расширения](#ReactRun)
      - [Debug](#ReactRunDebug)
      - [Production](#ReactRunProduction)
  - [Vue расширение](#VueExtSettings)
    - [Настройка Vue-расширения](#VueSetUp)
    - [Встраивание Vue в UI](#VueOpenspaceView)
    - [Запуск Vue-расширения](#VueRun)
      - [Debug](#VueRunDebug)
      - [Production](#VueRunProduction)
- [Добавление в проект расширения к компонентам PilotWeb2D и PilotWeb3D](#FrontendComponentExtSettings)

### Инжектирование зависимостей 
- [Список инджектируемых интерфейсов](#ListOfInjectingTypes)
- [Инжектирование зависимостей в typescript-расширение](#TypeInjecting)
- [Инжектирование зависимостей в angular-расширение](#AngularInjecting)

### Описание интерфейсов и методов Pilot-Web-Server
[1. Интерфейсы поведения](#BehaviourInterfaces)
  - [IInitializable](#IInitializable)
  - [IDisposable](#IDisposable)

[2. Интерфейсы для встраивания в UI](#UIInterfaces)
  - [Панель инструментов IToolbar](#IToolbar)
    - [IToolbarBuilder](#IToolbarBuilder)
	- [IToolbarButtonItemBuilder](#IToolbarButtonItemBuilder)
    - [IToolbarToggleButtonItemBuilder](#IToolbarToggleButtonItemBuilder)
    - [IToolbarMenuButtonItemBuilder](#IToolbarMenuButtonItemBuilder)
    - [IToolbarItemSubmenuHandler](#IToolbarItemSubmenuHandler)
  - [Меню IMenu](#IMenu)
    - [IMenuBuilder](#IMenuBuilder)
    - [IMenuItemBuilder](#IMenuItemBuilder)
  - [Панель вкладок ITabs](#ITabs)
    - [ITabsBuilder](#ITabsBuilder)
    - [ITabItemBuilder](#ITabItemBuilder)
  - [Окно навигации пространств IPageNavigation](#IPageNavigation)
    - [IPageNavigationBuilder](#IPageNavigationBuilder)
    - [IPageNavigationSectionBuilder](#IPageNavigationSectionBuilder)
    - [IPageNavigationSectionElementBuilder](#IPageNavigationSectionElementBuilder)
  - [Диалог IDialogService](#IDialogService)
  - [Отображение HTML элементов IOpenspaceView](#IOpenspaceView)
  - [Объекты UI-контекста](#Context)
    - [ObjectsViewContext](#ObjectsViewContext)
    - [DocumentAnnotationsListContext](#DocumentAnnotationsListContext)
    - [PageContext](#PageContext)
    - [DialogContext](#DialogContext)
    - [BimElementPanelContext](#BimElementPanelContext)
    - [BimRightPanelContext](#BimRightPanelContext)
  - [Интерфейсы для работы с сертификатами и криптографией](#ICrypto)
    - [ICertificate](#ICertificate)
    - [ICryptoProvider](#ICryptoProvider)
  - [Интерфейсы для работы с личными настройками](#ISettingsFeature)
    - [ISettingsFeature](#ISettingsFeature)
    - [ISettingValueProvider](#ISettingValueProvider)

[3. Интерфейсы для перехвата событий клиентского приложения](#HandlerInterfaces)
  - [Перехват отображения атрибутов в карточке объекта IObjectCardHandler](#IObjectCardHandler)
    - [Редактирование атрибутов в карточке IAttributeModifier](#IAttributeModifier)
    - [Контекст карточки ObjectCardContext](#ObjectCardContext)
  - [Перехват цветовой схемы клиента](#ThemeInterfaces)
	- [IThemeService](#ThemeService)
    
[4. Интерфейсы управления данными](#DataManagementInterfaces)
  - [IObjectsRepository](#IObjectsRepository)
  - [IRepositoryEvents](#IRepositoryEvents)
  - [IModifierProvider](#IModifierProvider)
  - [IModifier](#IModifier)
  - [IObjectBuilder](#IObjectBuilder)
  - [ISignatureModifier](#ISignatureModifier)
  - [ISignatureBuilder](#ISignatureBuilder)
  - [IPersonalSettings](#IPersonalSettings)
  - [IBimFeatures](#IBimFeatures)
    - [IBimSearchSetService](#IBimSearchSetService)

[5. Интерфейсы контекста визуального представления документа](#DocumentInterfaces)
  - [IRenderContextProvider](#IRenderContextProvider)
  - [RenderContext](#RenderContext)

[6. Интерфейсы контекста визуального представления пространства модели](#BIMInterfaces)
  - [BimElementPanelContext](#BimElementPanelContext)
  - [BimRightPanelContext](#BimRightPanelContext)

[7. Дополнительные интерфейсы и утилиты](#AdditionalInterfaces)
  - [ExpectedError](#ExpectedError)
  

## Описание настройки сборки расширений

<a name="Recomendation"></a>

### Общая информация 

Расширения для **Pilot-Web-Server** могут состоять из следующих компонентов:
- backend-расширение (.NET)
- frontend-расширение (angular, react, vue, js, ts)
- расширения к компонентам [Pilot-ComponentKit](https://pilot.ascon.ru/componentkit) 

<a name="FrontendExtSetup"></a>

### Настройка и запуск проекта frontend-расширения

<a name="TypeScriptExtSettings"></a>

#### TypeScript расширение

<a name="TypeScriptSetUp"></a>

##### Настройка TypeScript-расширения

Чтобы создать новое TypeScript-расширение для **Pilot-Web-Server** выполните следующие действия:
- Установите **Node.js**.

- Создайте проект с помощью пакетного менеджера **npm** командой
```sh
npm init
```
Можно пользоваться и другими пакетными менеджерами (например, **yarn**), однако примеры будут приведены для **npm**.

- Откройте терминал в окружении проекта и выполните команды:
```sh
npm i @pilotdev/pilot-web-sdk
npm i --save-dev typescript ts-loader webpack webpack-cli copy-webpack-plugin
```

- Добавьте в **package.json** в блок **scripts** строчки:
```diff
  {
    "scripts": {
      ...,
+     "build": "webpack",
+     "build-prod": "webpack --config webpack.prod.config.js"
    },
    "dependencies": {
      ...
    },
    ...
  }
```

- Создайте файл **src\assets\extensions.config.json** с содержимым: 
```json
{
  "manifestVersion": 1,
  "author": "",
  "license": "",
  "title": "",
  "version": "",
  "extension": {
    "name": "ext_name",
    "entry": "ext_name.js",
    "modules": []
  }
}
```
и заполните поля **author**, **license**, **title**, **version**, **name**, a так же поле **entry** по шаблону `[name].js`, где [name] - значение поля name. Например: `ext_name.js`.

!!! tip Интерактивные подсказки и валидация в IDE
    В начале файла добавьте поле **$schema** со значением пути, указывающим на схему **extensions.config.schema.json** из пакета **@pilotdev/pilot-web-sdk**
    ```json
    {
      "$schema": "../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json",
      ...
    }
    ```


- Добавьте в корневую папку файл **tsconfig.json** командой 
```sh
npx tsc --init
```

- Добавьте в корневую папку файл **webpack.config.js** с содержимым:
```js
const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require("copy-webpack-plugin");
module.exports = [{ 
  mode: "development",
  entry: {main: './src/index.ts'},
  module: {
    rules: [{
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/ 
    }]
  },
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'ext_name',
    scriptType: 'text/javascript',
    filename: '[name].js',
    clean: true
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'ext_name',
      library: { type: 'var', name: '[name]' },
      filename: '[name].js',
      exposes: [],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    }),

    new CopyPlugin({
      patterns: [
        { from: "./src/assets/extensions.config.json", to: "extensions.config.json" }
      ],
    }),
  ]
}]
```
и заполните поле **uniqueName** в блоке **output** и поле **name** в параметре конструктора **ModuleFederationPlugin**. Значения должны совпадать со значением name из **extensions.config.json**.

- Добавьте в корневую папку файл **webpack.prod.config.js** с содержимым:

```js
const { merge } = require("webpack-merge");
const dev = require("./webpack.config.js");

module.exports = merge(dev, {
  mode: "production",
});
```

- Создайте файл `src\app\extensionSample.ts`, в котором будет содержаться логика расширения, например:
```ruby
import { IMenu, IMenuBuilder, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";
export class ExtensionSample extends IMenu<ObjectsViewContext> {
  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
  }
}
```

- В файлы **webpack.config.js** и **webpack.prod.config.js** добавьте информацию о реализуемых интерфейсах из sdk в поле **exposes** конструктора плагина **ModuleFederationPlugin** в формате [интерфейс]:[путь к файлу].
```diff
const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require("copy-webpack-plugin");
module.exports = [{ 
  mode: "development",
  entry: {main: './src/index.ts'},
  module: {
    rules: [{
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/ 
    }]
  },
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'ext_name',
    scriptType: 'text/javascript',
    filename: '[name].js',
    clean: true
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'ext_name',
      library: { type: 'var', name: '[name]' },
      filename: '[name].js',
-     exposes: [],
+     exposes: [
+       {'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts'}
+     ],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    }),

    new CopyPlugin({
      patterns: [
        { from: "./src/assets/extensions.config.json", to: "extensions.config.json" }
      ],
    }),
  ]
}]
```

- Так же в файл **extensions.config.json** в блок `extension.modules` добавьте информацию о созданных классах в поля **ngModuleName** (имя класса) и **exposedInterface** (реализуемый интерфейс), например:
```diff
  {
    "manifestVersion": 1,
    "author": "",
    "license": "",
    "title": "",
    "version": "",
    "extension": {
      "name": "ext_name",
      "entry": "ext_name.js",
-     "modules": [],
+     "modules": [
+       { "ngModuleName":"ExtensionSample", "exposedInterface":"IMenu<ObjectsViewContext>" }
+     ]
    }
  }
```

<a name="TypeScriptRun"></a>

##### Запуск TypeScript-расширения

<a name="TypeScriptRunDebug"></a>

###### Debug

Для того чтобы собрать расширение в отладочном режиме, запустите скрипт **build**:
```sh
npm run build
```
Затем запустите контейнер с Pilot-Web-Server с ключом `-e AppSettings:Mode=Development`
```sh
docker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest
```

Далее предоставьте доступ к папке **dist** по порту `4300` - это можно сделать, например, запустив плагин **Live Server** для **Visual Studio Code** с конфигурационным файлом `\.vscode\settings.json`
```json
{
  "liveServer.settings.root": "./dist",
  "liveServer.settings.port": 4300
}
```

<a name="TypeScriptRunProduction"></a>

###### Production

Для того чтобы собрать и запустить production-расширение, запустите скрипт **build-prod**:
```sh
npm run build-prod
```

Затем в папке **dist** создайте zip архив с папкой **frontend** (сама папка должна попасть в архив). В клиентском приложении **Pilot** создайте объект с типом **Веб-расширение (WebExtension)** и прикрепите архив. Подробнее на [help.pilotems.com](https://help.pilotems.com/ru/Content/plugin.htm?)

<a name="AngularExtSettings"></a>

#### Angular-расширение 

<a name="AngularSetUp"></a>

##### Настройка angular-расширения 

Чтобы создать angular-расширение, выполните следующие действия:

- Создайте новый angular-проект командой:
```sh
ng new angular-ext
```

- Выполните команды в окружении проекта:
```sh
npm install @pilotdev/pilot-web-sdk
npm install @angular-architects/module-federation --save-dev
```
*если произошла ошибка несовпадения версий зависимостей, то выполните команду:* 
```sh
npm config set legacy-peer-deps true
```

- Создайте в корне проекта файл **webpack.config.js** с содержимым:
```js
const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
module.exports = {
  output: {
    publicPath: 'auto',
    uniqueName: 'angular_ext',
    scriptType: 'text/javascript',
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'angular_ext',
      library: { type: 'var', name: 'angular-ext' },
      filename: '[name].js',
      exposes: {
      },
      shared: {
        '@angular/core': {
          singleton: true,
        },
        '@angular/common': {
          singleton: true,
        },
        '@angular/forms': {
          singleton: true,
        },
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    })
  ]
};
``` 
и заполните поля **uniqueName**, **name** и **library.name**. Добавьте в секцию **shared** используемые библиотеки, чтобы их переиспользовать в хост-приложении. Подробнее: <https://webpack.js.org/plugins/module-federation-plugin>

- Выберите и установите пакет для кастомизации сборки angular-приложения. В примере будет показана установка c [angular-builders/custom-webpack](https://www.npmjs.com/package/@angular-builders/custom-webpack), но также можно выбрать и другие пакеты – например, [ngx-build-plus](https://www.npmjs.com/package/ngx-build-plus).
```sh
npm install @angular-builders/custom-webpack --save-dev
``` 

- Откройте файл **angular.json** и найдите поле `projects.angular-ext.architect.build.builder` и замените его на `@angular-builders/custom-webpack:browser` а также удалите поле `projects.angular-ext.architect.options.browser`.
```diff
  {
      ...
        "sourceRoot": "src",
        "prefix": "app",
        "architect": {
          "build": {
+           "builder": "@angular-builders/custom-webpack:browser",
            "options": {
              "outputPath": "dist/angular-ext",
              "index": "src/index.html",
              "polyfills": [
                "zone.js"
              ],
      ...
  }	  
``` 
- Затем найдите блок `projects.angular-ext.architect.build.options` и добавьте поля **customWebpackConfig** и **main**:
```diff
  {
    "$schema": "./node_modules/@angular/cli/lib/config/schema.json",
    "version": 1,
    "newProjectRoot": "projects",
    "projects": {
      "angular-ext": {
      ...
        "architect": {
          "build": {
            "builder": "@angular-builders/custom-webpack:browser",
            "options": {
              "outputPath": "dist/frontend",
              "index": "src/index.html",
+             "customWebpackConfig": {
+               "path": "webpack.config.js"
+              },
+             "main": "src/main.ts",
              "polyfills": [
                "zone.js"
              ],
    ...
  }
``` 

- Замените поле `projects.angular-ext.architect.serve.builder`:
```diff
  {
      ...
            "defaultConfiguration": "production"
          },
          "serve": {
+           "builder": "@angular-builders/custom-webpack:dev-server",
            "configurations": {
              "production": {
                "buildTarget": "angular-ext:build:production"
              },
              "development": {
                "buildTarget": "angular-ext:build:development"
              }
            },
            "defaultConfiguration": "development"
      ...
  }
``` 

- Замените поле `projects.angular-ext.architect.test.builder`:
```diff
  {
    ...
            "options": {
              "buildTarget": "angular.sample:build"
            }
          },
          "test": {
+           "builder": "@angular-builders/custom-webpack:karma",
            "options": {
              "polyfills": [
                "zone.js",
                "zone.js/testing"
              ],
              "tsConfig": "tsconfig.spec.json",
              "assets": [
                "src/favicon.ico",
                "src/assets"
              ],
              "styles": [
                "src/styles.css"
              ],
              "scripts": []
            }
      ...
  }
```

>Подробнее инструкцию настройки **angular-builders/custom-webpack** можно прочитать на <https://www.npmjs.com/package/@angular-builders/custom-webpack>


- В файле angular.json найдите поле `projects.angular-ext.architect.build.options.outputPath` и замените его
```diff
  {
      ...
      "build": {
        "builder": "@angular-builders/custom-webpack:browser",
        "options": {
+       "outputPath": "dist/frontend",
        "index": "src/index.html",
        "customWebpackConfig": {
          "path": "webpack.config.js"
        },
        "main": "src/main.ts",
        "polyfills": [
          "zone.js"
        ],
      ...
  }
 ```
- Создайте файл **src\config\extensions.config.json** с содержимым: 
```json
{
  "manifestVersion": 1,
  "author": "",
  "license": "",
  "title": "",
  "version": "",
  "extension": {
    "name": "angular_ext",
    "entry": "angular_ext.js",
    "modules": []
  }
}
```
и заполните поля **author**, **license**, **title**, **version**, **name**, a так же поле **entry** по шаблону `[name].js`, где [name] - значение поля name (например: `angular_ext.js`). Значение поля name должно совпадать со значением name из **webpack.config.js**.

!!! tip Интерактивные подсказки и валидация в IDE
    В начале файла добавьте поле **$schema** со значением пути, указывающим на схему **extensions.config.schema.json** из пакета **@pilotdev/pilot-web-sdk**
    ```json
    {
      "$schema": "../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json",
      ...
    }
    ```

- Добавьте в файл **angular.json** в блок `projects.angular-ext.architect.build.options.assets` запись о **extensions.config.json**:
```diff
  {
    ...
      "customWebpackConfig": {
        "path": "webpack.config.js"
      },
      "main": "src/main.ts",
      "polyfills": [
        "zone.js"
      ],
      "tsConfig": "tsconfig.app.json",
      "inlineStyleLanguage": "scss",
      "assets": [
+       { 
+         "glob": "extensions.config.json",
+         "input": "src/config",
+         "output": "./"
+       }
      ],	
    ...
  }
```
 
<details>
  <summary>Пример настроенного файла <b>angular.json</b>:</summary>
  <p>

```json
{
  "$schema": "./node_modules/@angular/cli/lib/config/schema.json",
  "version": 1,
  "newProjectRoot": "projects",
  "projects": {
    "angular-ext": {
      "projectType": "application",
      "schematics": {
        "@schematics/angular:component": {
          "style": "scss"
        }
      },
      "root": "",
      "sourceRoot": "src",
      "prefix": "app",
      "architect": {
        "build": {
          "builder": "@angular-builders/custom-webpack:browser",
          "options": {
            "outputPath": "dist/frontend",
            "index": "src/index.html",
            "customWebpackConfig": {
              "path": "webpack.config.js"
            },
            "main": "src/main.ts",
            "polyfills": [
              "zone.js"
            ],
            "tsConfig": "tsconfig.app.json",
            "inlineStyleLanguage": "scss",
            "assets": [
              {
                "glob": "extensions.config.json",
                "input": "src/config",
                "output": "./"
              }
            ],
            "styles": [
              "src/styles.scss"
            ],
            "scripts": []
          },
          "configurations": {
            "production": {
              "budgets": [
                {
                  "type": "initial",
                  "maximumWarning": "500kb",
                  "maximumError": "1mb"
                },
                {
                  "type": "anyComponentStyle",
                  "maximumWarning": "2kb",
                  "maximumError": "4kb"
                }
              ],
              "outputHashing": "all"
            },
            "development": {
              "optimization": false,
              "extractLicenses": false,
              "sourceMap": true
            }
          },
          "defaultConfiguration": "production"
        },
        "serve": {
          "options": {
            "port": 4300,
            "publicHost": "http://localhost:4300"
          },
          "builder": "@angular-builders/custom-webpack:dev-server",
          "configurations": {
            "production": {
              "buildTarget": "angular-ext:build:production"
            },
            "development": {
              "buildTarget": "angular-ext:build:development"
            }
          },
          "defaultConfiguration": "development"
        },
        "extract-i18n": {
          "builder": "@angular-devkit/build-angular:extract-i18n",
          "options": {
            "buildTarget": "angular-ext:build"
          }
        },
        "test": {
          "builder": "@angular-builders/custom-webpack:karma",
          "options": {
            "polyfills": [
              "zone.js",
              "zone.js/testing"
            ],
            "tsConfig": "tsconfig.spec.json",
            "inlineStyleLanguage": "scss",
            "assets": [
              "src/favicon.ico",
              "src/assets"
            ],
            "styles": [
              "src/styles.scss"
            ],
            "scripts": []
          }
        }
      }
    }
  }
}
```
  </p>
</details>

- Создайте файл `extensionSample.ts`, в котором будет содержаться логика расширения, например:
```ruby
import { Inject, Injectable } from "@angular/core";
import { IMenu, IMenuBuilder, IObjectsRepository, ObjectsViewContext } from "@pilotdev/pilot-web-sdk"
@Injectable({providedIn: "root"})
export class ExtensionSample implements IMenu<ObjectsViewContext> {
  
  constructor(@Inject(`IObjectsRepository`)private _repository: IObjectsRepository) {
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    builder.addItem("SomeMenuItemName", 1)
      .withHeader("Hello from angular extension");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    alert(`Angular extension works!`);
  }
}
```

- В файлы **webpack.config.js** добавьте информацию о реализуемых интерфейсах из sdk в поле **exposes** конструктора плагина **ModuleFederationPlugin** в формате `IMenu<ObjectsViewContext>:./src/app/extensionSample.ts`:
```diff
  const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
  module.exports = {
    output: {
      publicPath: 'auto',
      uniqueName: 'angular_ext',
      scriptType: 'text/javascript',
    },
    optimization: {
      // fix a temporary bug
      runtimeChunk: false
    },
    plugins: [
      new ModuleFederationPlugin({
        name: 'angular_ext',
        library: { type: 'var', name: 'angular_ext' },
        filename: '[name].js',
-       exposes: {},
+       exposes: {
+         'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts' //added
+       },
        shared: {
          '@angular/core': {
            singleton: true,
          },
          '@angular/common': {
            singleton: true,
          },
          '@angular/forms': {
            singleton: true,
          },
          '@pilotdev/pilot-web-sdk': {
            singleton: true,
          }
        }
      })
    ]
  };
```

- Так же в файл **extensions.config.json** в блок `extension.modules` добавьте информацию о созданных классах в поля **ngModuleName** (имя класса) и **exposedInterface** (реализуемый интерфейс), например:
```diff
  {
    "manifestVersion": 1,
    "author": "",
    "license": "",
    "title": "",
    "version": "",
    "extension": {
      "name": "angular_ext",
      "entry": "angular_ext.js",
-     "modules": [],
+     "modules": [
+       { "ngModuleName":"ExtensionSample", "exposedInterface":"IMenu<ObjectsViewContext>" }
+     ]
    }
  }	
```
- В файл **main.ts** добавьте запись о созданном файле через **import**, например:
```ruby
import { bootstrapApplication } from '@angular/platform-browser';
import { appConfig } from './app/app.config';
import { AppComponent } from './app/app.component';
import * as ext from "./app/extensionSample" 
bootstrapApplication(AppComponent, appConfig)
  .catch((err) => console.error(err));
```

<a name="AngularOpenspaceView"></a>

##### Встраивание Angular в UI

Для встраивания Angular в приложение, реализуйте интерфейс [`IOpenspaceView`](#IOpenspaceView) с необходимым контекстом, например:

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class AngularView implements IOpenspaceView<PageContext> {
  getViewId(): string {
  }

  getView(): HTMLElement | undefined {
  }
}
```

Реализуйте метод [`getViewId()`](#IOpenspaceView.getViewId) для идентификации отображения:
```ruby
getViewId(): string {
  return "AngularViewId";
}
```

Реализуйте метод [`getView()`](#IOpenspaceView.getView):
- Создайте корневой HTML элемент отображения, используя `document.createElement`
- Создайте экземпляр приложения Angular при помощи функции [`createApplication()`](https://v17.angular.io/api/platform-browser/createApplication), при надобности передав в аргумент объект с требуемыми провайжерами и получите ссылку [`ApplicationRef`](https://v17.angular.io/api/core/ApplicationRef) на приложение.
- Получите зону Angular [`NgZone`](https://v17.angular.io/api/core/NgZone) при помощи метода [`ApplicationRef.injector.get()`](https://v17.angular.io/api/core/EnvironmentInjector#get), передав в аргумент класс [`NgZone`](https://v17.angular.io/api/core/NgZone).
- В контексте метода [`NgZone.run()`](https://v17.angular.io/api/core/NgZone#run):
  - Получите ссылку на экземпляр компонента [`ComponentRef`](https://v17.angular.io/api/core/ComponentRef) при помощи функции [`createComponent()`](https://v17.angular.io/api/core/createComponent), передав в аргумент класс компонента и объект с инжектором экземпляра приложения [`AppRef.injector`](https://v17.angular.io/api/core/ApplicationRef#injector) и корневым HTML элементом отображения.
  - Вызовите метод [`ApplicationRef.attachView()`](https://v17.angular.io/api/core/ApplicationRef#attachview), передав ему [`ComponentRef.hostView`](https://v17.angular.io/api/core/ComponentRef#hostView).

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { ApplicationRef, ComponentRef, createComponent, Injectable, NgZone } from '@angular/core';
import { createApplication } from '@angular/platform-browser';

import { AppComponent } from '../../app.component';

export class AngularView implements IOpenspaceView<PageContext> {
  private _rootElement: HTMLElement | undefined;
  private _appRef: ApplicationRef | undefined;
  private _componentRef: ComponentRef<AppComponent> | undefined;

  ...

  getView(): HTMLElement | undefined {
    if (!this._rootElement) {
      this._rootElement = document.createElement("div");
    }

    if (!this._appRef) {
      createApplication({
        providers: [],
      }).then((appRef: ApplicationRef) => {
        this._appRef = appRef;

        const zone = appRef.injector.get(NgZone);
        zone.run(() => {
          this._componentRef = createComponent(AppComponent, {
            environmentInjector: appRef.injector,
            hostElement: this._rootElement,
          });

          appRef.attachView(this._componentRef.hostView);
        });
      });
    }

    return this._rootElement;
  }
}
```

Для освобождения ресурсов, необходимо реализовать интерфейс поведения [`IDisposable`](#IDisposable) и его метод `IDisposable.dispose()`:
- Вызовите метод [`ComponentRef.destroy`](https://v17.angular.io/api/core/ComponentRef#destroy) экземпляра компонента Angular
- Вызовите метод [`ApplicationRef.destroy`](https://v17.angular.io/api/core/ApplicationRef#destroy) экземпляра приложения Angular
- Очистите корневой HTML элемент отображения

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { ApplicationRef, ComponentRef } from '@angular/core';

import { AppComponent } from '../../app.component';

export class AngularView implements IOpenspaceView<PageContext> {
  private _rootElement: HTMLElement | undefined;
  private _appRef: ApplicationRef | undefined;
  private _componentRef: ComponentRef<AppComponent> | undefined;

  ...

  dispose(): void {
    if (this._componentRef) {
      this._componentRef.destroy();
      this._componentRef = undefined;
    }

    if (this._appRef) {
      this._appRef.destroy();
      this._appRef = undefined;
    }

    if (this._rootElement) {
      this._rootElement = undefined;
    }
  }
}
```

<a name="AngularRun"></a>

##### Запуск angular-расширения 

<a name="AngularRunDebug"></a>

###### Debug 

Для того чтобы собрать расширение в отладочном режиме, настройте запуск на порту `4300`. Для этого добавьте в **angular.json** в `projects.angular-ext.architect.serve` поле **options**:
```diff
  {
            ...
            "defaultConfiguration": "production"
          },
          "serve": {
+           "options": {
+             "port": 4300,
+             "publicHost": "http://localhost:4300"
+           },
            "builder": "@angular-builders/custom-webpack:dev-server",
            "configurations": {
              "production": {
                "buildTarget": "angular-ext:build:production"
              },
              "development": {
                "buildTarget": "angular-ext:build:development"
              }
            ...
  }
``` 
После этого можно запустить скрипт **start**:
```sh
npm run start
```

Затем запустите запустите контейнер с **Pilot-Web-Server** с ключом `-e AppSettings:Mode=Development`
```sh
docker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest
```

<a name="AngularRunProduction"></a>

###### Production 

Для того чтобы собрать и запустить production-расширение, добавьте в файл **package.json** скрипт **build-prod**:
```diff
  {
    ...
    "scripts": {
      ...,
      "start": "ng serve",
      "build": "ng build",
+     "build-prod": "webpack --config webpack.prod.config.js",
      ...
    },
    "private": true,
    "dependencies": {
      ...
    },
    ...
  }
```

И запустите его:
```sh
npm run build-prod
```

Затем в папке **dist** создайте zip-архив с папкой frontend (сама папка должна попасть в архив). В клиентском приложении **Pilot** создайте объект с типом **Веб-расширение (WebExtension)** и прикрепите архив. Подробнее на [help.pilotems.com](https://help.pilotems.com/ru/Content/plugin.htm?)

<a name="ReactExtSettings" />

#### React-расширение

<a name="ReactSetUp"></a>

##### Настройка React-расширения

Чтобы создать новое React-расширение для **Pilot-Web-Server** выполните следующие действия:
- Установите **Node.js**.

- Создайте проект с помощью пакетного менеджера **npm** командой
```sh
npm init
```
Можно пользоваться и другими пакетными менеджерами (например, **yarn**), однако примеры будут приведены для **npm**.

- Откройте терминал в окружении проекта и выполните команды для установки :
```sh
npm i react react-dom @pilotdev/pilot-web-sdk
npm i --save-dev webpack webpack-cli copy-webpack-plugin html-webpack-plugin
npm i --save-dev ts-loader style-loader css-loader
npm i --save-dev typescript typescript-plugin-css-modules @types/copy-webpack-plugin @types/node @types/react @types/react-dom
```

- Добавьте в корневую папку файл **tsconfig.json** командой 
```sh
npx tsc --init
```

- Измените содержание **tsconfig.json** на следующее: 
```json
{
  "compilerOptions": {
    "jsx": "react-jsx",
    "allowSyntheticDefaultImports": true,
    "baseUrl": ".",
    "outDir": "./dist/out-tsc",
    "sourceMap": true,
    "declaration": false,
    "downlevelIteration": true,
    "experimentalDecorators": true,
    "module": "esnext",
    "moduleResolution": "node",
    "importHelpers": true,
    "target": "ES2022",
    "typeRoots": ["node_modules/@types"],
    "lib": ["es2020", "dom"],
    "allowJs": true,
    "strict": true,
    "plugins": [{ "name": "typescript-plugin-css-modules" }]
  },
  "include": ["**/*.ts", "**/*.tsx"]
}
```

- Добавьте в **package.json** в блок **scripts** строчки:
```diff
  {
    "scripts": {
      ...,
+     "dev": "webpack serve",
+     "build-prod": "webpack --config webpack.prod.config.js",
    },
    "dependencies": {
      ...
    },
    ...
  }
```

- Создайте файл **src\extension\extensions.config.json** с содержимым: 
```json
{
  "manifestVersion": 1,
  "author": "",
  "license": "",
  "title": "",
  "version": "",
  "extension": {
    "name": "react-ext",
    "entry": "react-ext.js",
    "modules": []
  }
}
```
и заполните поля **author**, **license**, **title**, **version**, **name**, a так же поле **entry** по шаблону `[name].js`, где [name] - значение поля name. Например: `react-ext.js`.

!!! tip Интерактивные подсказки и валидация в IDE
    В начале файла добавьте поле **$schema** со значением пути, указывающим на схему **extensions.config.schema.json** из пакета **@pilotdev/pilot-web-sdk**
    ```json
    {
      "$schema": "../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json",
      ...
    }
    ```


- Добавьте в корневую папку файл **webpack.config.js** с содержимым:

```js
const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require('copy-webpack-plugin');
const HtmlWebpackPlugin = require('html-webpack-plugin');

module.exports =
{
  mode: 'development',
  entry: { main: './src/index.tsx' },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
      {
        test: /\.css$/i,
        use: [
          'style-loader',
          { loader: 'css-loader', options: { modules: true } },
        ],
      },
    ],
  },
  resolve: {
    extensions: ['.tsx', '.ts', '.jsx', '.js', '.json'],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'react-ext',
    scriptType: 'text/javascript',
    filename: '[name].js',
    clean: true,
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false,
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: './src/index.html',
    }),
    new ModuleFederationPlugin({
      name: 'react-ext',
      library: {
        type: 'var',
        name: 'react-ext',
      },
      filename: '[name].js',
      exposes: [
      ],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        },
      },
    }),
    new CopyPlugin({
      patterns: [
        {
          from: './src/extension/extensions.config.json',
          to: 'extensions.config.json',
        },
      ],
    }),
  ],
  devServer: {
    port: 4300,
    allowedHosts: 'auto',
    headers: {
      'Access-Control-Allow-Origin': '*',
    },
  },
};
```
и заполните поле **uniqueName** в блоке **output** и поле **name** в параметре конструктора **ModuleFederationPlugin**. Значения должны совпадать со значением name из **extensions.config.json**.

- Добавьте в корневую папку файл **webpack.prod.config.js** с содержимым:

```js
const { merge } = require("webpack-merge");
const dev = require("./webpack.config.js");

module.exports = merge(dev, {
  mode: "production",
});
```

- Создайте файл `src\extension\reactView.ts`, в котором будет содержаться логика расширения, например:

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class ReactView implements IOpenspaceView<PageContext> {
  getViewId(): string {
  }

  getView(): HTMLElement | undefined {
  }
}
```

- В файлы **webpack.config.js** и **webpack.prod.config.js** добавьте информацию о реализуемых интерфейсах из sdk в поле **exposes** конструктора плагина **ModuleFederationPlugin** в формате [интерфейс]:[путь к файлу].

```diff
  const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
  const CopyPlugin = require('copy-webpack-plugin');
  const HtmlWebpackPlugin = require('html-webpack-plugin');

  module.exports =
  {
    mode: 'development',
    entry: { main: './src/index.tsx' },
    module: {
      rules: [
        {
          test: /\.tsx?$/,
          use: 'ts-loader',
          exclude: /node_modules/,
        },
        {
          test: /\.css$/i,
          use: [
            'style-loader',
            { loader: 'css-loader', options: { modules: true } },
          ],
        },
      ],
    },
    resolve: {
      extensions: ['.tsx', '.ts', '.jsx', '.js', '.json'],
    },
    output: {
      publicPath: 'auto',
      uniqueName: 'react-ext',
      scriptType: 'text/javascript',
      filename: '[name].js',
      clean: true,
    },
    optimization: {
      // fix a temporary bug
      runtimeChunk: false,
    },
    plugins: [
      new HtmlWebpackPlugin({
        template: './src/index.html',
      }),
      new ModuleFederationPlugin({
        name: 'react-ext',
        library: {
          type: 'var',
          name: 'react-ext',
        },
        filename: '[name].js',
-       exposes: [],
+       exposes: [
+         {'IOpenspaceView<PageContext>': './src/extension/reactView.ts'}
+       ],
        shared: {
          '@pilotdev/pilot-web-sdk': {
            singleton: true,
          },
        },
      }),
      new CopyPlugin({
        patterns: [
          {
            from: './src/extension/extensions.config.json',
            to: 'extensions.config.json',
          },
        ],
      }),
    ],
    devServer: {
      port: 4300,
      allowedHosts: 'auto',
      headers: {
        'Access-Control-Allow-Origin': '*',
      },
    },
  };
```

- Так же в файл **extensions.config.json** в блок `extension.modules` добавьте информацию о созданных классах в поля **ngModuleName** (имя класса) и **exposedInterface** (реализуемый интерфейс), например:
```diff
  {
    "manifestVersion": 1,
    "author": "",
    "license": "",
    "title": "",
    "version": "",
    "extension": {
      "name": "react-ext",
      "entry": "react-ext.js",
-     "modules": [],
+     "modules": [
+       { "ngModuleName":"ReactView", "exposedInterface":"IOpenspaceView<PageContext>" }
+     ]
    }
  }
```

<a name="ReactOpenspaceView"></a>

##### Встраивание React в UI

Для встраивания React в приложение, реализуйте интерфейс [`IOpenspaceView`](#IOpenspaceView) с необходимым контекстом, например:

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class ReactView implements IOpenspaceView<PageContext> {
  getViewId(): string {
  }

  getView(): HTMLElement | undefined {
  }
}
```

Реализуйте метод [`getViewId()`](#IOpenspaceView.getViewId) для идентификации отображения:
```ruby
getViewId(): string {
  return "ReactViewId";
}
```

Реализуйте метод [`getView()`](#IOpenspaceView.getView):
- Создайте корневой HTML элемент отображения, используя `document.createElement`
- Создайте экземпляр приложения React при помощи функции [`createRoot`](https://react.dev/reference/react-dom/client/createRoot), передав ему корневой HTML элемент отображения
- Создайте экземпляр компонента при помощи функции [`createElement`](https://react.dev/reference/react/createElement), для отладки воспользуйтесь компонентом [`StrictMode`](https://react.dev/reference/react/StrictMode)
- Вызовите метод [`root.render`](https://react.dev/reference/react-dom/client/createRoot#root-render) экземпляра приложения React, передав ему экземпляр компонента

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { StrictMode, createElement } from 'react';
import { createRoot, Root } from 'react-dom/client';

import { ReactViewComponent } from '../../components/ReactView';

export class ReactView implements IOpenspaceView<PageContext> {
  private _rootElement: HTMLElement | undefined;
  private _reactRoot: Root | undefined;

  ...

  getView(): HTMLElement | undefined {
    if (!this._rootElement) {
      this._rootElement = document.createElement("div");
    }

    if (!this._reactRoot) {
      this._reactRoot = createRoot(this._rootElement);
    }

    const element = createElement(ReactViewComponent);

    const strictModeElement = createElement(StrictMode, { children: element });

    if (this._reactRoot) {
      this._reactRoot.render(strictModeElement);
    }

    return this._rootElement;
  }
}
```

Для освобождения ресурсов, необходимо реализовать интерфейс поведения [`IDisposable`](#IDisposable) и его метод `IDisposable.dispose()`:
- Вызовите метод [`root.unmount`](https://react.dev/reference/react-dom/client/createRoot#root-unmount) экземпляра приложения React
- Очистите корневой HTML элемент отображения

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { StrictMode, createElement } from 'react';
import { createRoot, Root } from 'react-dom/client';

import { ReactViewComponent } from '../../components/ReactView';

export class ReactView implements IOpenspaceView<PageContext> {
  private _rootElement: HTMLElement | undefined;
  private _reactRoot: Root | undefined;

  ...

  dispose(): void {
    if (this._reactRoot) {
      this._reactRoot.unmount();
      this._reactRoot = undefined;
    }

    if (this._rootElement) {
      this._rootElement = undefined;
    }
  }
}
```

<a name="ReactRun"></a>

##### Запуск React-расширения

<a name="ReactRunDebug"></a>

###### Debug

Для того чтобы собрать расширение в отладочном режиме, запустите скрипт **dev**:
```sh
npm run dev
```
Затем запустите контейнер с Pilot-Web-Server с ключом `-e AppSettings:Mode=Development`
```sh
docker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest
```

<a name="ReactRunProduction"></a>

###### Production

Для того чтобы собрать и запустить production-расширение, запустите скрипт **build-prod**:
```sh
npm run build-prod
```

Затем в папке **dist** создайте zip архив с папкой **frontend** (сама папка должна попасть в архив). В клиентском приложении **Pilot** создайте объект с типом **Веб-расширение (WebExtension)** и прикрепите архив. Подробнее на [help.pilotems.com](https://help.pilotems.com/ru/Content/plugin.htm?)

<a name="VueExtSettings" />

#### Vue-расширение

<a name="VueSetUp"></a>

##### Настройка Vue-расширения

Чтобы создать Vue-расширение, выполните следующие действия:
- Установите утилиту vue-cli командой:
```sh
npm install -g @vue/cli
```

- Создайте новый Vue-проект командой:
```sh
vue create vue-ext
```

- Выполните команды в окружении проекта:
```sh
npm install @pilotdev/pilot-web-sdk
```
*если произошла ошибка несовпадения версий зависимостей, то выполните команду:* 
```sh
npm config set legacy-peer-deps true
```

- Добавьте в **package.json** в блок **scripts** строчки:
```diff
  {
    "scripts": {
      ...,
+     "serve": "vue-cli-service serve",
+     "build-prod": "vue-cli-service build",
      ...
    },
    "dependencies": {
      ...
    },
    ...
  }
```

- Создайте файл **src\assets\extensions.config.json** с содержимым: 
```json
{
  "manifestVersion": 1,
  "author": "",
  "license": "",
  "title": "",
  "version": "",
  "extension": {
    "name": "vue-ext",
    "entry": "vue-ext.js",
    "modules": []
  }
}
```
и заполните поля **author**, **license**, **title**, **version**, **name**, a так же поле **entry** по шаблону `[name].js`, где [name] - значение поля name. Например: `vue-ext.js`.

!!! tip Интерактивные подсказки и валидация в IDE
    В начале файла добавьте поле **$schema** со значением пути, указывающим на схему **extensions.config.schema.json** из пакета **@pilotdev/pilot-web-sdk**
    ```json
    {
      "$schema": "../../../node_modules/@pilotdev/pilot-web-sdk/extensions.config.schema.json",
      ...
    }
    ```

- В корне проекта измените содержимое файла **vue.config.js** на следующее:

```js
const { defineConfig } = require("@vue/cli-service");

const ModuleFederationPlugin = require("webpack/lib/container/ModuleFederationPlugin");
const CopyPlugin = require("copy-webpack-plugin");

const isProduction = process.env.NODE_ENV === "production";

module.exports = defineConfig({
  transpileDependencies: true,
  publicPath: "auto",
  outputDir: isProduction ? "./dist/frontend" : undefined,
  configureWebpack: () => {
    return {
      entry: "./src/main.ts",
      output: {
        uniqueName: "vue-ext",
        scriptType: "text/javascript",
        filename: "[name].js",
        clean: true,
      },
      optimization: {
        // fix a temporary bug
        runtimeChunk: false,
        splitChunks: isProduction ? undefined : false,
      },
      plugins: [
        new ModuleFederationPlugin({
          name: "vue-ext",
          library: {
            type: "var",
            name: "vue-ext",
          },
          filename: "[name].js",
          exposes: [
          ],
          shared: {
            "@pilotdev/pilot-web-sdk": {
              singleton: true,
            },
          },
        }),
        new CopyPlugin({
          patterns: [
            {
              from: "./src/extension/extensions.config.json",
              to: `extensions.config.json`,
            },
          ],
        }),
      ],
      devServer: isProduction
        ? undefined
        : {
            port: 4300,
            allowedHosts: "auto",
            headers: { "Access-Control-Allow-Origin": "*" },
          },
    };
  },
});
```
и заполните поля **uniqueName**, **name** и **library.name**. Добавьте в секцию **shared** используемые библиотеки, чтобы их переиспользовать в хост-приложении. Подробнее: <https://webpack.js.org/plugins/module-federation-plugin>

- Создайте файл `src\extension\vueView.ts`, в котором будет содержаться логика расширения, например:

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class VueView implements IOpenspaceView<PageContext> {
  getViewId(): string {
  }

  getView(): HTMLElement | undefined {
  }
}
```

- В файл **vue.config.js** добавьте информацию о реализуемых интерфейсах из sdk в поле **exposes** конструктора плагина **ModuleFederationPlugin** в формате [интерфейс]:[путь к файлу].

```diff
  const { defineConfig } = require("@vue/cli-service");

  const ModuleFederationPlugin = require("webpack/lib/container/ModuleFederationPlugin");
  const CopyPlugin = require("copy-webpack-plugin");

  const isProduction = process.env.NODE_ENV === "production";

  module.exports = defineConfig({
    transpileDependencies: true,
    publicPath: "auto",
    outputDir: isProduction ? "./dist/frontend" : undefined,
    configureWebpack: () => {
      return {
        entry: "./src/main.ts",
        output: {
          uniqueName: "vue-ext",
          scriptType: "text/javascript",
          filename: "[name].js",
          clean: true,
        },
        optimization: {
          // fix a temporary bug
          runtimeChunk: false,
          splitChunks: isProduction ? undefined : false,
        },
        plugins: [
          new ModuleFederationPlugin({
            name: "vue-ext",
            library: {
              type: "var",
              name: "vue-ext",
            },
            filename: "[name].js",
-           exposes: [],
+           exposes: [
+             {'IOpenspaceView<PageContext>': './src/extension/vueView.ts'}
+           ],
            shared: {
              "@pilotdev/pilot-web-sdk": {
                singleton: true,
              },
            },
          }),
          new CopyPlugin({
            patterns: [
              {
                from: "./src/extension/extensions.config.json",
                to: `extensions.config.json`,
              },
            ],
          }),
        ],
        devServer: isProduction
          ? undefined
          : {
              port: 4300,
              allowedHosts: "auto",
              headers: { "Access-Control-Allow-Origin": "*" },
            },
      };
    },
  });
```

- Так же в файл **extensions.config.json** в блок `extension.modules` добавьте информацию о созданных классах в поля **ngModuleName** (имя класса) и **exposedInterface** (реализуемый интерфейс), например:
```diff
  {
    "manifestVersion": 1,
    "author": "",
    "license": "",
    "title": "",
    "version": "",
    "extension": {
      "name": "vue-ext",
      "entry": "vue-ext.js",
-     "modules": [],
+     "modules": [
+       { "ngModuleName":"VueView", "exposedInterface":"IOpenspaceView<PageContext>" }
+     ]
    }
  }
```

<a name="VueOpenspaceView"></a>

##### Встраивание Vue в UI

Для встраивания Vue в приложение, реализуйте интерфейс [`IOpenspaceView`](#IOpenspaceView) с необходимым контекстом, например:

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class VueView implements IOpenspaceView<PageContext> {
  getViewId(): string {
  }

  getView(): HTMLElement | undefined {
  }
}
```

Реализуйте метод [`getViewId()`](#IOpenspaceView.getViewId) для идентификации отображения:
```ruby
getViewId(): string {
  return "VueViewId";
}
```

Реализуйте метод [`getView()`](#IOpenspaceView.getView):
- Создайте корневой HTML элемент отображения, используя `document.createElement`
- Создайте экземпляр приложения Vue при помощи функции [`createApp`](https://vuejs.org/api/application.html#createapp)
- Вызовите метод [app.mount](https://vuejs.org/api/application.html#app-mount) экземпляра приложения Vue, передав ему корневой HTML элемент отображения

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { createApp, type App as AppType } from "vue";
import App from "../../App.vue";

export class VueView implements IOpenspaceView<PageContext> {
  private _rootElement: HTMLElement | undefined;
  private _vueApp: AppType<Element> | undefined;

  ...

  getView(): HTMLElement | undefined {
    if (!this._rootElement) {
      this._rootElement = document.createElement("div");
      this._rootElement.setAttribute("id", "app");
    }

    if (!this._vueApp) {
      this._vueApp = createApp(App);
    }

    this._vueApp.mount(this._rootElement);

    return this._rootElement;
  }
}
```

Для освобождения ресурсов, необходимо реализовать интерфейс поведения [`IDisposable`](#IDisposable) и его метод `IDisposable.dispose()`:
- Вызовите метод [app.unmount](https://vuejs.org/api/application.html#app-unmount) экземпляра приложения Vue
- Очистите корневой HTML элемент отображения

```ruby
import { IDisposable, IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";
import { createApp, type App as AppType } from "vue";

export class VueView implements IOpenspaceView<PageContext>, IDisposable {
  private _rootElement: HTMLElement | undefined;
  private _vueApp: AppType<Element> | undefined;

  ...

  dispose(): void {
    if (this._vueApp) {
      this._vueApp.unmount();
      this._vueApp = undefined;
    }

    if (this._rootElement) {
      this._rootElement = undefined;
    }
  }
}
```

<a name="VueRun"></a>

##### Запуск Vue-расширения

<a name="VueRunDebug"></a>

###### Debug

Для того чтобы собрать расширение в отладочном режиме, запустите скрипт **serve**:
```sh
npm run serve
```
Затем запустите контейнер с Pilot-Web-Server с ключом `-e AppSettings:Mode=Development`
```sh
docker run -d -p 80:80 -e PilotServer:Url=http://0.1.5.100:5545 -e PilotServer:Database=demo -e AppSettings:Mode=Development --name pilot-web-server pilotdev/pilot-web-server:latest
```

<a name="VueRunProduction"></a>

###### Production

Для того чтобы собрать и запустить production-расширение, запустите скрипт **build-prod**:
```sh
npm run build-prod
```

Затем в папке **dist** создайте zip архив с папкой **frontend** (сама папка должна попасть в архив). В клиентском приложении **Pilot** создайте объект с типом **Веб-расширение (WebExtension)** и прикрепите архив. Подробнее на [help.pilotems.com](https://help.pilotems.com/ru/Content/plugin.htm?)

<a name="FrontendComponentExtSettings"></a>

### Добавление в проект расширения к компонентам PilotWeb2D и PilotWeb3D

Чтобы добавить расширение к компонентам **Pilot-ComponentKit**, выполните следующие действия:
 
- Добавьте файл `src\app\web2d.component.extension.ts`, в котором будет содержаться логика расширения, например:
```ruby
/// <reference types="@pilotdev/pilot-web-2d" />
export class Web2DExtension extends PilotWeb2D.Extension {
  static readonly EXTENSION_NAME = "ProductName.Web2DExtension";

  constructor(_viewer: PilotWeb2D.GuiViewer2D) {
    super(_viewer);
  }
  
  override getName() {
    return Web2DExtension.EXTENSION_NAME;
  }

  override load() : boolean | Promise<boolean> {
    super.activate();
    return super.load();
  }

  override unload(): boolean {
    super.deactivate();
	return super.unload();
  }
}
PilotWeb2D.theExtensionManager.registerExtensionType(Web2DExtension.EXTENSION_NAME, Web2DExtension);
```
 
- Добавьте в файлах **webpack.config.js** и **webpack.prod.config.js** информацию о созданном файле: в поле **entry** добавьте ключ-значение `[key]:[path to ext file]`.
```diff
  const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
  const CopyPlugin = require("copy-webpack-plugin");
  module.exports = [{ 
    mode: "development",
-   entry: './src/index.ts',
+   entry: {
+     main: './src/index.ts',
+	    web2d: './src/app/web2d.component.extension.ts',
+   },
    module: {
      rules: [{
          test: /\.tsx?$/,
          use: 'ts-loader',
          exclude: /node_modules/ 
      }]
    },
    resolve: {
      extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
    },
    output: {
      publicPath: 'auto',
      uniqueName: 'ext_name',
      scriptType: 'text/javascript',
      filename: '[name].js',
      clean: true
    },
    optimization: {
      // fix a temporary bug
      runtimeChunk: false
    },
    plugins: [
      new ModuleFederationPlugin({
        name: 'ext_name',
        library: { type: 'var', name: '[name]' },
        filename: '[name].js',
        exposes: [{'IMenu<ObjectsViewContext>': './src/app/extensionSample.ts'}],  //implemented interfaces
        shared: {
          '@pilotdev/pilot-web-sdk': {
            singleton: true,
          }
        }
      }),

      new CopyPlugin({
        patterns: [
          { from: "./src/assets/extensions.config.json", to: "extensions.config.json" }
        ],
      }),
    ]
  }]
```
 
- Добавьте в файл **extensions.config.json** блок с ключом **pilotWeb2D** или **pilotWeb3D** с описанием расширения:
 ```diff
  {
    "manifestVersion": 1,
    "author": "",
    "license": "",
    "title": "",
    "version": "",
    "extension": {
      "name": "ext_name",
      "description": "",
      "entry": "ext_name.js",
      "modules": [
        { "ngModuleName":"ExtensionSample", "exposedInterface":"IMenu<ObjectsViewContext>" } ]
    },
+   "pilotWeb2D": [
+     {
+       "name": "Web2DExtension",
+       "description": "",
+       "entry": "web2d.js"  
+     }
+   ],
+   "pilotWeb3D": [
+     {
+       "name": "Web3DExtension",
+       "description": "",
+       "entry": "web3d.js"  
+     }
+   ]
  }
 ```
и заполните поля **name**, **description**, a так же поле **entry** по шаблону `[key].js`, где `[key]` - ключ из предыдущего шага. Например, `web2d.js`. Значение поля name должно совпадать с именем расширения, указанного в файле с логикой расширения (EXTENSION_NAME):
```ruby
PilotWeb2D.theExtensionManager.registerExtensionType(EXTENSION_NAME, Web2DExtension);
```

>Пример настройки клиентского расширения и расширения к компоненту и их взаимодействия – **annotation.page.changer**

<a name="Injecting"></a>

## Инжектирование зависимостей
 
<a name="ListOfInjectingTypes"></a>
### Список инжектируемых интерфейсов 

- [IObjectsRepository](#IObjectsRepository)
- [IRenderContextProvider](#IRenderContextProvider)
- [IModifierProvider](#IModifierProvider)
- [IRepositoryEvents](#IRepositoryEvents)

<a name="TypeInjecting"></a>
### Инжектирование зависимостей в typescript-расширение

Для инжектирования зависимостей имплементируйте интерфейс [`IInitializable`](#IInitializable): в метод `initialize` будет передан класс [`InjectionSource`](#InjectionSource), позволяющий получить экземпляры [IObjectsRepository](#IObjectsRepository), [IRenderContextProvider](#IRenderContextProvider), [IModifierProvider](#IModifierProvider), [IRepositoryEvents](#IRepositoryEvents).

```ruby
import { IDataPlugin, IModifierProvider, IObjectsRepository, IRenderContextProvider, IRepositoryEvents, IInitializable, InjectionSource } from "@pilotdev/pilot-web-sdk";

export class InitializeSample extends IDataPlugin implements IInitializable {

  private _objectsRepository!: IObjectsRepository;
  private _renderContextProvider!: IRenderContextProvider;
  private _modifierProvider!: IModifierProvider;
  private _repositoryEvents!: IRepositoryEvents;

  initialize(injectionSource: InjectionSource) {
    this._objectsRepository = injectionSource.objectsRepository;
    this._renderContextProvider = injectionSource.renderContextProvider;
    this._modifierProvider = injectionSource.modifierProvider;
    this._repositoryEvents = injectionSource.repositoryEvents;
  }
}
```

<a name="AngularInjecting"></a>

### Инжектирование зависимостей в angular-расширение

Для инжектирования зависимостей в angular-расширение укажите интерфейсы с использованием декоратора **Inject** в конструкторе класса, в котором содержится логика расширения, а также пометьте класс декоратором **Injectable**, например: 

```ruby
import { Inject, Injectable } from "@angular/core";
import { IMenu, IMenuBuilder, IModifierProvider, IObjectsRepository, IRenderContextProvider, IRepositoryEvents, ObjectsViewContext } from "@pilotdev/pilot-web-sdk"

@Injectable({providedIn: "root"})
export class ObjectsContextMenuExtension implements IMenu<ObjectsViewContext> {
  
  constructor(@Inject(`IObjectsRepository`)private _repository: IObjectsRepository,
              @Inject(`IRenderContextProvider`)private _renderContextProvider: IRenderContextProvider,
              @Inject(`IModifierProvider`)private _modifierProvider: IModifierProvider,
              @Inject(`IRepositoryEvents`)private _repositoryEvents: IRepositoryEvents) {
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    builder.addItem("SomeMenuItemName", 1)
      .withHeader("Hello from angular extension");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    alert(`Angular extension works!`);
  }
}
```

## Описание интерфейсов и методов Pilot-Web-Server

<a name="BehaviourInterfaces"></a>

## 1. Интерфейсы поведения

<a name="IInitializable"></a>

### Интерфейс IInitializable

Интерфейс используется для инжектирования зависимостей в расширение.

```ruby
import { IMenu, IMenuBuilder, ObjectsViewContext, IModifierProvider, IObjectsRepository, ObjectsViewContext, IInitializable, InjectionSource } from "@pilotdev/pilot-web-sdk";

export class InitializeSample extends IMenu<ObjectsViewContext> implements IInitializable {

  private _objectsRepository!: IObjectsRepository;
  private _modifierProvider!: IModifierProvider;

  initialize(injectionSource: InjectionSource) {
    this._objectsRepository = injectionSource.objectsRepository;
    this._modifierProvider = injectionSource.modifierProvider;
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    ...
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    ...
  }
}
```

#### IInitializable.initialize

Метод вызывается для инжектирования зависимостей

```ruby
initialize(injectionSource: InjectionSource): void
```
где:
 - `injectionSource` - класс, позволяющий получить доступ к экземплярам инжектируемых интерфейсов.

<a name="InjectionSource"></a>

#### InjectionSource

Класс, содержащий экземпляры инжектируемых интерфейсов. Подробнее: [Инжектирование зависимостей в typescript-расширение](#TypeInjecting).

<a name="IDisposable"></a>

### Интерфейс IDisposable

Интерфейс используется для реализации поведения расширения при его выгрузке.

```ruby
import { IMenu, IMenuBuilder, ObjectsViewContext, IDisposable } from "@pilotdev/pilot-web-sdk";

export class DisposeSample extends IMenu<ObjectsViewContext> implements IDisposable {
  dispose() {
    console.log("DisposeSample disposed!");
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    ...
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    ...
  }
}
```

#### IDisposable.dispose

Метод будет вызван при выгрузке объекта расширения из рабочей области: например при выполнении выхода из профиля или переключения элемента в [IOpenspaceView<ObjectsViewContext>](#IOpenspaceView).

```ruby
dispose(): void
```

<a name="UIInterfaces"></a>

## 2. Интерфейсы для встраивания в UI 

<a name="IToolbar"></a>

### Интерфейс IToolbar<TToolbarContext>

Интерфейс встраивает новые команды в панель инструментов. 

```ruby
import { IToolbar, IToolbarBuilder, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class ToolbarSample extends IToolbar<ObjectsViewContext> {

  build(builder: IToolbarBuilder, context: ObjectsViewContext): void {
	...
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
	...
  }
}
```

#### IToolbar<TMenuContext>.build

Метод вызывается перед построением панели инструментов.

```ruby
 build(builder: IToolbarBuilder, context: TToolbarContext): void
```
где:
 - `builder` - интерфейс, позволяющий добавлять различные элементы в меню.
 - `context` - контекст, позволяющий получить дополнительные сведения о селектированных элементах.

#### IToolbar<TMenuContext>.onToolbarItemClick

Метод вызывается при нажатии на элемент панели инструментов.

```ruby
 onToolbarItemClick(name: string, context: TToolbarContext): void
```
где:
 - `name` - уникальное внутреннее имя элемента панели инструментов.
 - `context` - контекст выполнения команды.

<a name="IToolbarBuilder"></a>

#### IToolbarBuilder

Управляет элементами панели инструментов.

##### IToolbarBuilder.itemNames

Свойство возвращает список уникальных имен элементов панели инструментов.

```ruby
get itemNames(): string[]
```

#### `IToolbarBuilder.count`

Свойство возвращает количество элементов панели инструментов.

```ruby
get count(): number
```

##### IToolbarBuilder.addSeparator

Метод добавляет разделитель в панель инструментов.

```ruby
addSeparator(index: number): void
```
где:
 - `index` - индекс, куда вставить разделитель.
 
##### IToolbarBuilder.addButtonItem

Метод добавляет кнопку в панель инструментов.

```ruby
addButtonItem(name: string, index: number): IToolbarButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя кнопки.
 - `index` - индекс, куда вставить кнопку.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

##### IToolbarBuilder.addMenuButtonItem

Метод добавляет кнопку с выпадающим меню в панель инструментов.

```ruby
addButtonItem(name: string, index: number): IToolbarButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя кнопки.
 - `index` - индекс, куда вставить кнопку.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.
 
##### IToolbarBuilder.addToggleButtonItem

Метод добавляет кнопку-переключатель в панель инструментов.

```ruby
addToggleButtonItem(name: string, index: number): IToolbarToggleButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя кнопки.
 - `index` - индекс, куда вставить кнопку.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

##### IToolbarBuilder.replaceButtonItem

Метод заменяет любой элемент панели инструментов на кнопку.

```ruby
replaceButtonItem(name: string): IToolbarButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя элемента, который будет заменен.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.
  
##### IToolbarBuilder.replaceMenuButtonItem

Метод заменяет любой элемент панели инструментов на кнопку с выпадающим меню.

```ruby
replaceMenuButtonItem(name: string): IToolbarMenuButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя элемента, который будет заменен.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.
 
##### IToolbarBuilder.replaceToggleButtonItem

Метод заменяет любой элемент панели инструментов на кнопку-переключатель.

```ruby
replaceToggleButtonItem(name: string): IToolbarToggleButtonItemBuilder
```
где:
 - `name` - уникальное внутреннее имя элемента, который будет заменен.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.
 
##### IToolbarBuilder.handleMenuButtonItemSubmenu

Метод добавляет обработчик построения подменю. Прямой доступ к элементам подменю невозможно получить в произвольный момент времени, так как подменю строится "лениво" при его открытии.

```ruby
handleMenuButtonItemSubmenu(name: string, itemSubmenuHandler: IToolbarItemSubmenuHandler): void
```
где:
 - `name` - имя элемента меню, в который будет встраиваться обработчик.
 - `itemSubmenuHandler` - обработчик построения подменю (реализуется на стороне модуля расширения).

##### IToolbarBuilder.removeItem

Метод удаляет элемент панели инструментов.

```ruby
removeItem(itemName: string): void
```
где:
 - `itemName` - уникальное внутреннее имя.


<a name="IToolbarButtonItemBuilder"></a>

#### IToolbarButtonItemBuilder

Интерфейс добавляет свойства к элементу панели инструментов.

##### IToolbarButtonItemBuilder.withHeader

Метод добавляет отображаемое в UI название.

```ruby
withHeader(header: string): IToolbarButtonItemBuilder
```
где:
 - `header` - отображаемое в UI название пункта меню.

##### IToolbarButtonItemBuilder.withIcon

Метод добавляет иконку в формате **SVG**. Входные данные: строка в формате **base64** или **url**.

```ruby
withIcon(name: string, svg: string): IToolbarButtonItemBuilder
```
где:
 - `name` - внутреннее имя иконки.
 - `svg` - иконка в формате **url** или **base64**.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

```ruby
  build(builder: IToolbarBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item", 1)
      .withHeader("ext command")
	  .withIcon( `ext_icon`, `http://localhost:4300/icon.svg`); //url format
  }
  
  build2(builder: IToolbarBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item2", 2)
      .withHeader("ext command 2")
	  .withIcon( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...`); //base64 format
  }
```
 
##### IToolbarButtonItemBuilder.withIsEnabled

Метод задаёт значение доступности элемента.

```ruby
withIsEnabled(value: boolean): IToolbarButtonItemBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

##### IToolbarButtonItemBuilder.withHint

Метод добавляет подсказку к элементу панели инструментов.

```ruby
withHint(hint: string): IToolbarButtonItemBuilder
```
где:
 - `hint` - текст подсказки.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

<a name="IToolbarToggleButtonItemBuilder"></a>

#### IToolbarToggleButtonItemBuilder

Добавляет свойства к кнопке-переключателю панели инструментов. Этот интерфейс является наследником **IToolbarButtonItemBuilder**.

##### IToolbarToggleButtonItemBuilder.withIsChecked

Метод задаёт состояние кнопки-переключателя.

```ruby
withIsChecked(value: boolean): IToolbarToggleButtonItemBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **IToolbarToggleButtonItemBuilder**.

<a name="IToolbarMenuButtonItemBuilder"></a>

#### IToolbarMenuButtonItemBuilder

Добавляет свойства к кнопке с выпадающим меню панели инструментов. Этот интерфейс является наследником **IToolbarButtonItemBuilder**.

##### IToolbarMenuButtonItemBuilder.withMenu

Метод добавляет контекстное меню к кнопке.

```ruby
 withMenu(itemSubmenuHandler: IToolbarItemSubmenuHandler): IToolbarMenuButtonItemBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **IToolbarMenuButtonItemBuilder**.

<a name="IToolbarItemSubmenuHandler"></a>

#### IToolbarItemSubmenuHandler

Интерфейс построения меню для кнопки панели инструментов. Для того, чтобы построить меню, необходимо реализовать этот интерфейс и передать экземпляр в IToolbarBuilder.handleMenuButtonItemSubmenu.

##### IToolbarItemSubmenuHandler.onSubmenuRequested

Метод вызывается перед тем, как появится меню у кнопки панели инструментов.

```ruby
onSubmenuRequested(builder: IToolbarBuilder): void
```
где:
 - `builder` - интерфейс построения меню.

<a name="IMenu"></a>

### Интерфейс IMenu<TMenuContext>

Интерфейс встраивает новые команды в различные меню приложения в зависимости от контекста. 

```ruby
import { IMenu, IMenuBuilder, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class MenuSample extends IMenu<ObjectsViewContext> {

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
	...
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
	...
  }
}
```

#### `IMenu<TMenuContext>.build`

Метод вызывается перед построением контекстного меню.

```ruby
build(builder: IMenuBuilder, context: TMenuContext): void
```
где:
 - `builder` - интерфейс, добавляющий различные элементы в меню.
 - `context` - контекст с дополнительными сведениями о селектированных элементах.


#### `IMenu<TMenuContext>.onMenuItemClick`

Метод вызывается при нажатии на элемент меню.

```ruby
onMenuItemClick(name: string, context: TMenuContext): void
```
где:
 - `name` - уникальное внутреннее имя элемента меню.
 - `context` - контекст выполнения команды.
 
<a name="IMenuBuilder"></a>
 
#### Интерфейс IMenuBuilder

Интерфейс управляет элементами меню.

##### IMenuBuilder.itemNames

Свойство возвращает список уникальных имен меню.

```ruby
get itemNames(): string[]
```

#### `IMenuBuilder.count`

Свойство возвращает количество элементов меню.

```ruby
get count(): number
```

##### IMenuBuilder.addSeparator

Метод добавляет разделитель в меню.

```ruby
addSeparator(index: number): void
```
где:
 - `index` - индекс, куда вставить разделитель.
 
 
##### IMenuBuilder.addItem

Метод добавляет пункт меню.

```ruby
addItem(name: string, index: number): IMenuItemBuilder
```
где:
 - `name` - уникальное внутреннее имя пункта меню.
 - `index` - индекс, куда вставить пункт меню.
 - `returns` - экземпляр **IMenuItemBuilder**.
 
##### IMenuBuilder.addCheckableItem

Метод добавляет пункт меню типа кнопка-переключатель.

```ruby
addCheckableItem(name: string, index: number): ICheckableMenuItemBuilder
```
где:
 - `name` - уникальное внутреннее имя пункта меню.
 - `index` - индекс, куда вставить пункт меню.
 - `returns` - экземпляр **ICheckableMenuItemBuilder**.

##### IMenuBuilder.replaceItem 

Метод заменяет любой пункт меню.

```ruby
replaceItem(name: string): IMenuItemBuilder
```
где:
 - `name` - уникальное внутреннее имя.
 - `returns` - экземпляр **IMenuItemBuilder**.

##### IMenuBuilder.removeItem 

Метод удаляет пункт меню.

```ruby
removeItem(name: string): void
```
где:
 - `name` - уникальное внутреннее имя.

##### IMenuBuilder.getItem  

Метод получает конструктор пункта меню.
 
```ruby
getItem(name: string): IMenuBuilder
```
где:
 - `name` - уникальное внутреннее имя.
 - `returns` - экземпляр **IMenuBuilder**.
  
 <a name="IMenuItemBuilder"></a>
 
#### IMenuItemBuilder

Интерфейс добавляет свойства пункту меню.

##### IMenuItemBuilder.withHeader

Метод добавляет отображаемое в UI название.

```ruby
withHeader(header: string): IMenuItemBuilder
```
где:
 - `header` - отображаемое в UI название пункта меню.
 - `returns` - экземпляр **IMenuItemBuilder**.

##### IMenuItemBuilder.withIcon

Метод добавляет иконку в формате **SVG**. Входные данные: строка в формате **base64** или **url**.

```ruby
withIcon(name: string, svg: string): IMenuItemBuilder
```
где:
 - `name` - внутреннее имя иконки.
 - `svg` - иконка в формате **url** или **base64**.
 - `returns` - экземпляр **IToolbarButtonItemBuilder**.

```ruby
  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item", 1)
      .withHeader("ext command")
	  .withIcon( `ext_icon`, `http://localhost:4300/icon.svg`); //url format
  }
  
  build2(builder: IMenuBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item2", 2)
      .withHeader("ext command 2")
	  .withIcon( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...`); //base64 format
  }
```
 
 
##### IMenuItemBuilder.withIsEnabled

Метод задаёт значение доступности элемента.

```ruby
withIsEnabled(value: boolean): IMenuItemBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **IMenuItemBuilder**.

##### IMenuItemBuilder.withSubmenu

Метод добавляет подменю к текущему пункту меню.

```ruby
withSubmenu(): IMenuBuilder
```
где:
 - `returns` - экземпляр IMenuItemBuilder.

<a name="ITabs"></a>

### Интерфейс ITabs<TTabsContext>

Интерфейс позволяет встраивать/изменять элементы в различных группах вкладок приложения в зависимости от контекста. 

```ruby
import { ITabs, ITabsBuilder, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class TabsSample extends ITabs<ObjectsViewContext> {

  build(builder: ITabsBuilder, context: ObjectsViewContext): void {
	...
  }
}
```

#### `ITabs<TTabsContext>.build`

Метод вызывается перед построением группы вкладок.

```ruby
build(builder: ITabsBuilder, context: TTabsContext): void
```
где:
 - `builder` - интерфейс, добавляющий различные элементы в группу вкладок.
 - `context` - контекст с дополнительными сведениями о селектированных элементах.
 
<a name="ITabsBuilder"></a>
 
#### Интерфейс ITabsBuilder

Интерфейс управляет элементами группы вкладок.

##### ITabsBuilder.itemNames

Свойство возвращает список уникальных имен вкладок.

```ruby
get itemNames(): string[]
```

#### `ITabsBuilder.count`

Свойство возвращает количество элементов группы вкладок.

```ruby
get count(): number
```

##### ITabsBuilder.addItem

Метод добавляет вкладку в группу.

```ruby
addItem(id: string, index: number): ITabItemBuilder
```
где:
 - `id` - уникальное внутреннее имя пункта меню.
 - `index` - индекс, куда вставить пункт меню.
 - `returns` - экземпляр **ITabItemBuilder**.

##### ITabsBuilder.replaceItem 

Метод заменяет любую вкладку в группе.

```ruby
replaceItem(id: string): ITabItemBuilder
```
где:
 - `id` - уникальное внутреннее имя.
 - `returns` - экземпляр **ITabItemBuilder**.

<a name="ITabItemBuilder"></a>
 
#### ITabItemBuilder

Интерфейс добавляет свойства вкладке.

##### ITabItemBuilder.withTitle

Метод добавляет отображаемое в UI название.

```ruby
withTitle(title: string): ITabItemBuilder
```
где:
 - `title` - отображаемое в UI название пункта меню.
 - `returns` - экземпляр **ITabItemBuilder**.

##### ITabItemBuilder.withIcon

Метод добавляет иконку в формате **SVG**. Входные данные: строка в формате **base64** или **url**.

```ruby
withIcon(name: string, iconSvg: string): ITabItemBuilder
```
где:
 - `name` - внутреннее имя иконки.
 - `svg` - иконка в формате **url** или **base64**.
 - `returns` - экземпляр **ITabItemBuilder**.

```ruby
  build(builder: ITabItemBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item", 1)
      .withTitle("ext command")
	  .withIcon( `ext_icon`, `http://localhost:4300/icon.svg`); //url format
  }
  
  build2(builder: ITabItemBuilder, context: ObjectsViewContext): void {
    builder.addItem("new_item2", 2)
      .withTitle("ext command 2")
	  .withIcon( `ext_icon`, `PD94bWwgdmVyc2lvbj0iMS4wIiB...`); //base64 format
  }
```

##### ITabItemBuilder.withViewId

Метод создает Openspace контейнер в теле вкладки с указанным id.

Id сопоставляется с соответствующим отображением [`IOpenspaceView.getViewId`](#IOpenspaceView.getViewId)

```ruby
withViewId(value: string): ITabItemBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **ITabItemBuilder**.

<a name="IPageNavigation"></a>

### Интерфейс IPageNavigation

Интерфейс управляет секциями и элементами **Окна навигации пространств**.

```ruby
import { IPageNavigation, IPageNavigationBuilder } from "@pilotdev/pilot-web-sdk";

export class PageNavigationSample extends IPageNavigation {

  build(builder: IPageNavigationBuilder): void {
	...
  }
}
```

#### IPageNavigation.build

Метод вызывается перед построением окна навигации.

```ruby
build(builder: IPageNavigationBuilder): void
```
где:
 - `builder` - интерфейс, управляющий секциями окна навигации.

#### IPageNavigationBuilder

Интерфейс управляет секциями окна навигации.

##### IPageNavigationBuilder.sectionIds

Свойство возвращает список уникальных id секций.

```ruby
get sectionIds(): string[]
```

##### IPageNavigationBuilder.count

Свойство возвращает количество секций окна навигации.

```ruby
get count(): number
```

##### IPageNavigationBuilder.addSection

Метод добавляет секцию в окно навигации.

```ruby
addItem(id: string, index: number): IPageNavigationSectionBuilder
```
где:
 - `id` - уникальный внутренний id секции.
 - `index` - индекс, куда вставить секцию.
 - `returns` - экземпляр **IPageNavigationSectionBuilder**.

##### IPageNavigationBuilder.replaceSection

Метод заменяет любую секцию в окне навигации.

```ruby
replaceItem(id: string): IPageNavigationSectionBuilder
```
где:
 - `id` - уникальный внутренний id секции.
 - `returns` - экземпляр **IPageNavigationSectionBuilder**.

#### IPageNavigationSectionBuilder

Интерфейс добавляет свойства секции и управляет её элементами.

##### IPageNavigationSectionBuilder.withTitle

Метод добавляет отображаемое в UI название секции.

```ruby
withTitle(title: string): IPageNavigationSectionBuilder
```
где:
 - `title` - отображаемое в UI название секции.
 - `returns` - экземпляр **IPageNavigationSectionBuilder**.

##### IPageNavigationSectionBuilder.elementIds

Свойство возвращает список уникальных id элементов секции.

```ruby
get elementIds(): string[]
```

##### IPageNavigationSectionBuilder.count

Свойство возвращает количество элементов секции.

```ruby
get count(): number
```

##### IPageNavigationSectionBuilder.addElement

Метод добавляет элемент в секцию окна навигации.

```ruby
addItem(id: string, index: number): IPageNavigationSectionElementBuilder
```
где:
 - `id` - уникальный внутренний id элемента.
 - `index` - индекс, куда вставить элемент.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

##### IPageNavigationSectionBuilder.replaceElement

Метод заменяет любой элемент в секции окна навигации.

```ruby
replaceItem(id: string): IPageNavigationSectionElementBuilder
```
где:
 - `id` - уникальный внутренний id элемента.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

#### IPageNavigationSectionElementBuilder

Интерфейс добавляет свойства элементу секции.

##### IPageNavigationSectionElementBuilder.withTitle

Метод добавляет отображаемое в UI название элемента.

```ruby
withTitle(title: string): IPageNavigationSectionElementBuilder
```
где:
 - `title` - отображаемое в UI название элемента.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

##### IPageNavigationSectionElementBuilder.withDescription

Метод добавляет отображаемое в UI описание элемента.

```ruby
withDescription(description: string): IPageNavigationSectionElementBuilder
```
где:
 - `description` - отображаемое в UI описание элемента.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

##### IPageNavigationSectionElementBuilder.withIcon

Метод добавляет иконку в формате **SVG**. Входные данные: строка в формате **base64** или **url**.

```ruby
withIcon(name: string, iconSvg: string): IPageNavigationSectionElementBuilder
```
где:
 - `name` - внутреннее имя иконки.
 - `svg` - иконка в формате **url** или **base64**.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

##### IPageNavigationSectionElementBuilder.withViewId

Метод создает Openspace контейнер в теле страницы с указанным id.

Id сопоставляется с соответствующим отображением [`IOpenspaceView.getViewId`](#IOpenspaceView.getViewId)

```ruby
withViewId(value: string): IPageNavigationSectionElementBuilder
```
где:
 - `value` - значение.
 - `returns` - экземпляр **IPageNavigationSectionElementBuilder**.

<a name="IDialogService"></a>

### Сервис IDialogService

Сервис, который позволяет открывать диалог с произвольным контентом.

#### IDialogService.openDialogWithExit

Метод создает диалог с Openspace контейнером в теле страницы с указанным id.

Id сопоставляется с соответствующим отображением [`IOpenspaceView.getViewId`](#IOpenspaceView.getViewId)

```ruby
openDialogWithExit(viewId: string, context: DialogContext, title: string): Observable<unknown>;
```

где:
 - `viewId` - id Openspace-контейнера.
 - `context` - экземпляр контекста диалога **DialogContext**.
 - `title` - заголовок диалога.
 - `returns` - экземпляр **Observable<unknown>**, который позволяет подписаться на закрытие диалога.

<a name="IOpenspaceView"></a>

### Интерфейс IOpenspaceView<TOpenspaceViewContext>

Интерфейс позволяет встраивать HTML элемент в различные части интерфейса приложения (Openspace слоты/контейнеры) в зависимости от контекста.
Для реализации логики освобождения ресурсов, используйте наследование от класса `IDisposable`: метод `dispose()` будет вызван перед уничтожением Openspace контейнера и перед выгрузкой расширения.

```ruby
import { IOpenspaceView, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class OpenspaceViewSample implements IOpenspaceView<ObjectsViewContext>, IDisposable {
  getViewId(): string {
    ...
  }

  getView(context: ObjectsViewContext): void {
	  ...
  }

  dispose(): void {
    ...
  }
}
```

<a name="IOpenspaceView.getViewId"></a>

#### `IOpenspaceView<TOpenspaceViewContext>.getViewId`

Метод вызывается для сопоставления экземпляра интерфейса IOpenspaceView c Openspace контейнером.

```ruby
getViewId(): string
```

<a name="IOpenspaceView.getView"></a>

#### `IOpenspaceView<TOpenspaceViewContext>.getView`

Метод вызывается для встраивания HTML элемента в Openspace контейнер

```ruby
getView(context: TOpenspaceViewContext): HTMLElement | undefined
```
где:
 - `context` - контекст с дополнительными сведениями.

<a name="Context"></a>

### Объекты UI-контекста

<a name="ObjectsViewContext"></a>

#### ObjectsViewContext

Используйте этот тип контекста для встраивания в **Обозреватель элементов**. Доступные для встраивания интерфейсы:
- Контекстное меню ([`IMenu`](#IMenu))
- Панель инструментов ([`IToolbar`](#IToolbar))
- Группа вкладок ([`ITabs`](#ITabs))
- Содержимое вкладки ([`IOpenspaceView`](#IOpenspaceView))

```ruby
import { IMenu, IMenuBuilder, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";

export class MenuSample extends IMenu<ObjectsViewContext> {

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
	...
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
	...
  }
}
```

<a name="DocumentAnnotationsListContext"></a>

#### DocumentAnnotationsListContext

Используйте этот тип контекста для встраивания в **Замечания к документу**. Доступные для встраивания интерфейсы:
- Контекстное меню ([`IMenu`](#IMenu))
- Панель инструментов ([`IToolbar`](#IToolbar))

```ruby
import { IMenu, IMenuBuilder, DocumentAnnotationsListContext } from "@pilotdev/pilot-web-sdk";

export class MenuSample extends IMenu<DocumentAnnotationsListContext> {

  build(builder: IMenuBuilder, context: DocumentAnnotationsListContext): void {
	...
  }

  onMenuItemClick(name: string, context: DocumentAnnotationsListContext): void {
	...
  }
}
```

<a name="PageContext"></a>

#### PageContext

Используйте этот тип контекста для встраивания в **Страницу пространства**. Доступные для встраивания интерфейсы:
- Содержимое страницы ([`IOpenspaceView`](#IOpenspaceView))

```ruby
import { IOpenspaceView, PageContext } from "@pilotdev/pilot-web-sdk";

export class OpenspaceViewSample implements IOpenspaceView<PageContext> {
  getViewId(): string {
    ...
  }

  getView(context: PageContext): void {
    ...
  }
}
```

<a name="DialogContext"></a>

#### DialogContext
Используйте этот тип контекста для встраивания в диалог, который может быть вызван в UI через IDialogService. 
На данном примере описан вызов диалога по кнопке из контекстного меню:

```ruby
export class ExampleObjectExtension implements IMenu<ObjectsViewContext>, IInitializable {
  private readonly EXAMPLE_VIEW_ITEM_NAME = "ExampleViewItemName";

  private _objectsRepository!: IObjectsRepository;
  private _dialogService!: IDialogService;

  initialize(injectionSource: InjectionSource): void {
    this._objectsRepository = injectionSource.objectsRepository;
    this._dialogService = injectionSource.dialogService;
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext) {
    ...

    builder.addItem(this.EXAMPLE_VIEW_ITEM_NAME, 0).withHeader("Это диалог");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext) {
    this._dialogService.openDialogWithExit(ExtensionViewId, new DialogContext(context), "Dialog title");
  }
}
```

<a name="BimElementPanelContext"></a>

#### BimElementPanelContext
Используйте этот тип контекста для встраивания в левую панель (панель элемента) пространства "Информационного моделирования (BIM)". Доступные для встраивания интерфейсы:
- Группа вкладок ([`ITabs`](#ITabs))
- Содержимое вкладки ([`IOpenspaceView`](#IOpenspaceView))

```ruby
import { ITabs, ITabsBuilder, BimElementPanelContext } from "@pilotdev/pilot-web-sdk";

export class TabsSample extends ITabs<BimElementPanelContext> {

  build(builder: ITabsBuilder, context: BimElementPanelContext): void {
    ...
  }
}
```

```ruby
import { IOpenspaceView, BimElementPanelContext } from "@pilotdev/pilot-web-sdk";

export class OpenspaceViewSample implements IOpenspaceView<BimElementPanelContext> {
  getViewId(): string {
    ...
  }

  getView(context: BimElementPanelContext): void {
    ...
  }
}
```

<a name="BimRightPanelContext"></a>

#### BimRightPanelContext
Используйте этот тип контекста для встраивания в правую панель пространства "Информационного моделирования (BIM)". Доступные для встраивания интерфейсы:
- Группа вкладок ([`ITabs`](#ITabs))
- Содержимое вкладки ([`IOpenspaceView`](#IOpenspaceView))

```ruby
import { ITabs, ITabsBuilder, BimRightPanelContext } from "@pilotdev/pilot-web-sdk";

export class TabsSample extends ITabs<BimRightPanelContext> {

  build(builder: ITabsBuilder, context: BimRightPanelContext): void {
    ...
  }
}
```

```ruby
import { IOpenspaceView, BimRightPanelContext } from "@pilotdev/pilot-web-sdk";

export class OpenspaceViewSample implements IOpenspaceView<BimRightPanelContext> {
  getViewId(): string {
    ...
  }

  getView(context: BimRightPanelContext): void {
	  ...
  }
}
```

<a name="ICrypto"></a>

### Интерфейсы для работы с сертификатами и криптографией

<a name="ICertificate"></a>

#### Интерфейс ICertificate

Представляет сертификат с датами действия, информацией об издателе и субъекте.

##### Свойства

###### ICertificate.validToDate

Свойство возвращает дату окончания действия сертификата.

```ruby
get validToDate(): string
```

###### ICertificate.validFromDate

Свойство возвращает дату начала действия сертификата.

```ruby
get validFromDate(): string
```

###### ICertificate.issuer

Свойство возвращает издателя сертификата.

```ruby
get issuer(): string
```

###### ICertificate.subject

Свойство возвращает субъект сертификата.

```ruby
get subject(): string
```

<a name="ICryptoProvider"></a>

#### Интерфейс ICryptoProvider

Представляет криптографический провайдер для подписания, проверки и получения сертификатов.

##### Методы

###### ICryptoProvider.sign

Метод подписывает файл цифровой подписью с использованием предоставленного сертификата.

```ruby
sign(documentId: string, actualFile: IFile, arrayBuffer: ArrayBuffer, certificate: ICertificate, signatureRequestIds: string[]): Observable<string>
```

где:
  - `documentId` - ID документа.
  - `actualFile` - объект файла для дополнительной информации.
  - `arrayBuffer` - файл для подписания.
  - `certificate` - цифровой сертификат для использования при подписании.
  - `signatureRequestIds` - массив ID запросов на подпись.
  - `returns` - наблюдаемый объект, который возвращает цифровую подпись в виде строки.

###### ICryptoProvider.verify

Метод проверяет цифровую подпись файла.

```ruby
verify(file: ArrayBuffer, sign: ArrayBuffer, signatureRequest: ISignatureRequest): Observable<ISignatureVerificationResult>
```

где:
- `file` - файл для проверки.
- `sign` - цифровая подпись для проверки.
- `signatureRequest` - проверяемый запрос на подпись.
- `returns` - стуктура, описывающая результат проверки.

###### ICryptoProvider.verifyImportedSignature

Метод проверяет импортируемую цифровую подпись.

```ruby
verifyImportedSignature(file: ArrayBuffer, sign: ArrayBuffer): Observable<IImportedSignatureVerificationResult>
```

где:
- `file` - файл для проверки.
- `sign` - цифровая подпись для проверки.
- `returns` - стуктура, описывающая результат проверки.

###### ICryptoProvider.getCertificates

Метод получает список цифровых сертификатов.

```ruby
getCertificates(): Observable<ICertificate[]>
```

где:
- `returns` - наблюдаемый объект, который возвращает массив объектов **ICertificate**.


###### ICryptoProvider.canProcessAlgorithms

Метод определяет, может ли провайдер обрабатывать указанный алгоритм.

```ruby
  canProcessAlgorithms(publicKeyOid: string): boolean;
```
где:
  - `publicKeyOid` - oid публичного ключа сертификата. Например `1.2.840.113549.1.1.1`
  - `returns` - результат проверки.
  
  
###### ICryptoProvider.canProcessSignature

Метод определяет, может ли провайдер проверить подпись. Метод необходим во время импорта подписи, когда алгоритм подписания неизвестен.

```ruby
  canProcessSignature(signatureFile: ArrayBuffer): boolean
```
где:
  - `signatureFile` - подпись.
  - `returns` - результат проверки.

<a name="CadesType"></a>

#### CadesType {#CadesType}

Перечисление типа подписи.

```ruby
export enum CadesType {
  CadesBes = 0,
  CadesT = 1,
  CadesC = 2,
  CadesXLong = 3,
  CadesXLongType1 = 4
}
```



<a name="ISettingsFeature"></a>

### Интерфейс ISettingsFeature

Интерфейс позволяет регистрировать представление в диалоге настроек.

#### ISettingsFeature

Интерфейс для работы с элементами диалога настроек.

##### `key`

Метод для получения уникального идентификатора элемента настроек.

```typescript
get key(): string;
```

##### `title`

Метод для получения заголовка элемента настроек.

```typescript
get title(): string;
```

##### `editor`

Метод для получения редактора значений элемента настроек.

```typescript
get editor(): HTMLElement;
```

##### `setValueProvider`

Метод для установки поставщика значения настройки.

```typescript
setValueProvider(settingValueProvider: ISettingValueProvider): void;
```
где:
- `settingValueProvider` - поставщик значения настройки.

<a name="ISettingValueProvider"></a>

### Интерфейс ISettingValueProvider

Интерфейс для поставщика значения личной настройки.

#### ISettingValueProvider

Интерфейс для работы со значениями личных настроек.

##### `getValue`

Метод для получения текущего значения настройки.

```typescript
getValue(): string;
```
где:
- `returns` - текущее значение настройки.

##### `setValue`

Метод для установки значения настройки.

```typescript
setValue(value: string): void;
```
где:
- `value` - новое значение настройки.

<a name="HandlerInterfaces"></a>

## 3. Интерфейсы для перехвата событий клиентского приложения 

<a name="IObjectCardHandler"></a>

### Интерфейс IObjectCardHandler

Интерфейс позволяет реализовать работу с атрибутами, отображаемыми в карточке объекта.

```ruby
import { AttributeValueChangedEventArgs, IAttribute, IAttributeModifier, IObjectCardHandler, ObjectCardContext } from "@pilotdev/pilot-web-sdk";

export class ObjectCardHandlerSample implements IObjectCardHandler {

  handle(modifier: IAttributeModifier, context: ObjectCardContext): void {
	...
  }

  onValueChanged(sender: IAttribute, args: AttributeValueChangedEventArgs, modifier: IAttributeModifier): void {
	...
  }
}
```

#### IObjectCardHandler.handle

Метод `handle` вызывается при каждом построении карточки объекта: при показе диалогов создания и редактирования объекта, при выборе объектов, для которых отображается карточка, в Обозревателе документов. В случае, если карточка находится в режиме редактирования существующего объекта, свойство `editingObject` аргумента `context` возвращает сам объект, атрибуты которого показаны в карточке; и `null`, если карточка показана для создания нового объекта.

```ruby
handle(modifier: IAttributeModifier, context: ObjectCardContext): void
```
где:
 - `modifier` - интерфейс, позволяющий задавать новые значения для атрибутов.
 - `context` - контекст отображения карточки.

#### IObjectCardHandler.onValueChanged

Метод `onValueChanged` вызывается при изменении пользователем значения какого-либо из отображаемых атрибутов в карточке объекта. Аргумент `sender` возвращает атрибут, значение которого было изменено. Аргумент `args` позволяет получить доступ к аргументам события: предыдущему и новому значению атрибута, а также контексту карточки объекта. `modifier` позволяет отреагировать на изменения и установить новое значение дополнительно одному или нескольким атрибутам. Изменения в значениях атрибутов, которые были сделаны с помощью `modifier`, не приводят к вызовам метода `onValueChanged`.

```ruby
onValueChanged(sender: IAttribute, args: AttributeValueChangedEventArgs, modifier: IAttributeModifier): void
```
где:
 - `sender` - интерфейс, позволяющий добавлять различные элементы в меню.
 - `args` - контекст, позволяющий получить дополнительные сведения о селектированных элементах.
 - `modifier` - контекст, позволяющий получить дополнительные сведения о селектированных элементах.

<a name="IAttributeModifier"></a>

#### Редактирование атрибутов в карточке IAttributeModifier

Интерфейс позволяет установить новое значения для атрибутов элемента перед тем, как они будут показаны в карточке объекта.

##### IAttributeModifier.setValue

Метод позволяет задать новое значение атрибуту.

```ts
setValue(name: string, value: unknown): void
```
где:
 - `name` - уникальное наименование атрибута типа.
 - `value` - новое значение атрибута.

<a name="ObjectCardContext"></a>

#### Контекст карточки ObjectCardContext

Контекст отображения карточки.

##### ObjectCardContext.currentObjectId

Поле содержит идетификатор объекта, для которого показана карточка. Если карточка показана для создания нового объекта, то поле содержит идентификатор, который будет присвоен новому объекту при создании.

```ts
get currentObjectId(): string
```

##### ObjectCardContext.displayAttributes

Поле содержит список отображаемых в карточке атрибутов. В этот список не входят сервисные атрибуты.

```ts
get displayAttributes(): IAttribute[]
```

##### ObjectCardContext.attributeValues

Словарь текущих значений атрибутов карточки объекта, где ключ это имя атрибута, а значение - это значение атрибута.

```ts
get attributesValues(): Map<string, unknown>
```

##### ObjectCardContext.type

Поле содержит описание типа элемента, для которого показана карточка.

```ts
get type(): IType
```

##### ObjectCardContext.editiedObject

Текущий редактируемый объект, для которого показана карточка. null, если карточка показана для создания нового объекта.

```ts
get editedObject(): IDataObject | null
```

##### ObjectCardContext.parent

Поле содержит ID родительского элемента.

```ts
get parentId(): string;
```

##### ObjectCardContext.isReadOnly

True, если карточка в режиме только для чтения, и атрибуты недоступны для изменения.

```ts
get isReadOnly(): boolean;
```

<a name="ThemeInterfaces"></a>

### Перехват цветовой схемы клиента

<a name="ThemeService"></a>

#### IThemeService

Интерфейс позваляет получить значение выбранной цветовой схемы клиента (светлая или тёмная).

##### IThemeService.themes

Позволяет получить текущую цветовую схему клиента.

```ts
get themes(): Themes;
```

##### IThemeService.change

Позволяет подписаться на событие изменение цветовой схемы клиента.

```ts
get change(): Observable<Themes>;
```

<a name="DataManagementInterfaces"></a>

## 4. Интерфейсы управления данными

<a name="IObjectsRepository"></a>

### Интерфейс IObjectsRepository

Интерфейс даёт доступ к элементам, типам элементов и организационной структуре. Получить интерфейс можно с помощью [инжектирования](#Injecting). Для подписки на изменения данных смотри [IRepositoryEvents](#IRepositoryEvents).

##### IObjectsRepository.getObjects

Метод получает элементы по их идентификаторам.

```ruby
getObjects(ids: string[]): Observable<IDataObject[]>
```
где:
  - `ids` - список идентификаторов элементов.
  - `returns` - список объектов, обёрнутый в [Cold Observable](https://rxjs.dev/guide/glossary-and-semantics#cold). 
 
##### IObjectsRepository.getCurrentAccess

Метод получает информацию о доступе пользователя к определенному объекту.

```ruby
getCurrentAccess(objectId: string, personId: number): Observable<AccessLevel>
```
где:
  - `objectId` - идентификатор объекта.
  - `personId` - идентификатор пользователя.
  - `returns` - информация о доступе, обёрнутая в [Cold Observable](https://rxjs.dev/guide/glossary-and-semantics#cold). 
 
##### IObjectsRepository.getPerson

Метод позволяет получить информацию о пользователе по идентификатору.

```ruby
getPerson(id: number): IPerson
```

где:
  - `id` - идентификатор пользователя.
  - `returns` - пользователь. 

##### IObjectsRepository.getCurrentPerson

Метод возвращает текущего пользователя.

```ruby
getCurrentPerson(): IPerson
```
где:
  - `returns` - пользователь. 
  
##### IObjectsRepository.getPeople

Метод получает список всех пользователей.

```ruby
 getPeople(): IPerson[]
```
где:
  - `returns` - пользователи. 

##### IObjectsRepository.getType

Метод получает информацию о типе элемента по идентификатору.

```ruby
getType(id: number): IType
``` 
где:
  - `id` - идентификатор типа элемента.
  - `returns` - тип. 

##### IObjectsRepository.getTypeByName

Метод получает информацию о типе элемента по имени.

```ruby
getTypeByName(name: string): IType
``` 
где:
  - `name` - идентификатор типа элемента.
  - `returns` - имя типа элемента. 

##### IObjectsRepository.getTypes

Метод получает список всех типов.

```ruby
getTypes(): IType[]
```
где:
  - `returns` - типы.

##### IObjectsRepository.getOrganisationUnit 

Метод получает информацию об организационной единице.
```ruby
getOrganisationUnit(id: number): IOrganizationUnit
```
где:
  - `id` - идентификатор должности или подразделения.
  - `returns` - организационная единица.

##### IObjectsRepository.getOrganisationUnits

Метод получает список организационных единиц.

```ruby
  getOrganisationUnits(): IOrganizationUnit[]
```

где:
  - `returns` - список организационных единиц.
  
<a name="IRepositoryEvents"></a>

### Интерфейс IRepositoryEvents

Интерфейс подписывается на изменения в элементах, типах элементов и организационной структуре. Получить интерфейс можно с помощью [инжектирования](#Injecting).. Подписка – [Hot Observable](https://rxjs.dev/guide/glossary-and-semantics#hot) и срабатывает только на изменение данных.

##### IRepositoryEvents.subscribeObjects 

Метод подписывается на изменения элементов по идентификаторам.
```ruby
subscribeObjects(ids: string[]): Observable<IDataObject>
```
где:
  - `ids` - список идентификаторов элементов.
  - `returns` - подписка. 

##### IRepositoryEvents.subscribePeople 

Метод подписывается на изменения в пользователях.

```ruby
subscribePeople(): Observable<IPerson>
```
где:
  - `returns` - подписка. 
  
##### IRepositoryEvents.subscribeTypes 
  
Метод подписывается на изменения в типах.

```ruby
subscribeTypes(): Observable<IType>
```
где:
  - `returns` - подписка. 
  
##### IRepositoryEvents.subscribeOrganisationUnits 

Метод подписывается на изменения в организационных единицах (должностях и подразделениях).

```ruby
subscribeOrganisationUnits(): Observable<IOrganizationUnit>
```
где:
  - `returns` - подписка. 

<a name="IModifierProvider"></a>

### Интерфейс IModifierProvider

Интерфейс отдаёт объект **IModifier**. Получить интерфейс можно с помощью [инжектирования](#Injecting).

##### IModifierProvider.newModifier

Метод получает новый экземпляр класса, реализующий интерфейс [IModifier](#IModifier).

```ruby
newModifier(): IModifier
```
где:
  - `returns` - экземпляр **IModifier**. 
  
<a name="IModifier"></a>
 
### Интерфейс IModifier

Интерфейс предназначен для создания и изменения элементов. Получить интерфейс можно через [IModifierProvider](#IModifierProvider).

##### IModifier.create

Метод создаёт новый элемент заданного типа.

```ruby
create(id: string, parentId: string, typeId: number): IObjectBuilder
```
где: 
  - `id` - идентификатор нового элемента.
  - `parentId` - идентификатор родителя нового элемента.
  - `typeId` - идентификатор типа нового элемента.
  - `returns` - экземпляр **IObjectBuilder**.

##### IModifier.edit

Метод редактирует заданный элемент.

```ruby
edit(id: string) : IObjectBuilder
```
где:
 - `id` - идентификатор редактируемого элемента.

##### IModifier.apply

Метод применяет все сделанные над элементами изменения. Без вызова этого метода изменения не будут применены.

```ruby
apply(): Observable<IDataObject[]>;
```
где: 
  - `returns` - созданные и измененные объекты, обёрнутые в [Cold Observable](https://rxjs.dev/guide/glossary-and-semantics#cold). 
  
<a name="IObjectBuilder"></a>

### Интерфейс IObjectBuilder

Интерфейс редактирует элементы.
 
##### IObjectBuilder.setAttribute  

Метод задает или изменяет атрибут с заданным именем.

```ruby
setAttribute(name: string, value: any, type: AttributeType): IObjectBuilder
```
где: 
  - `name` - имя атрибута.
  - `type` - тип атрибута.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setAccess  

Метод добавляет права доступа на элемент.

```ruby
setAccess(record: IAccessRecord): IObjectBuilder
```
где: 
  - `record` - структура, описывающая права доступа.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.removeAccess  

Метод удаляет права доступа на элемент.

```ruby
removeAccess(record: IAccessRecord): IObjectBuilder
```
где: 
  - `record` - структура, описывающая права доступа.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.addRelation

Метод добавляет новую связь к элементу.

```ruby
addRelation(relation: IRelation): IObjectBuilder
```
где: 
  - `relation` - структура, описывающая связь.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.removeRelation

Метод удаляет связь.

```ruby
removeRelation(relationId: string): IObjectBuilder
```
где: 
  - `relationId` - идентификатор связи.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setTypeId

Метод задаёт элементу тип.
>**ВНИМАНИЕ!**
Рекомендуется использовать этот метод только для восстановления безвозвратно удаленных объектов. В остальных случаях это может привести к неработоспособности системы.

```ruby
setTypeId(typeId: number): IObjectBuilder
```
где: 
  - `typeId` - идентификатор типа.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setParentId

Метод задаёт элементу нового родителя.

```ruby
setParentId(parentId: string): IObjectBuilder
```

где: 
  - `parentId` - идентификатор элемента.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.createSnapshot

Метод создаёт снимок файлов и указывает причину. Текущие файлы будут сохранены в предыдущей версии документа.

```ruby
createSnapshot(reason: string): IObjectBuilder
```
где: 
  - `reason` - причина создания снимка файлов.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.createSnapshotFrom

Метод делает выбранный снимок файлов текущим.

```ruby
createSnapshotFrom(version: string, reason: string): IObjectBuilder
```
где: 
  - `version` - дата создания снимка, который нужно сделать актуальным.
  - `reason` - причина создания снимка файлов.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.addFile

Метод добавляет новый файл в текущий снимок файлов.

```ruby
addFile(fileId: string, file: File, creationTime: Date, lastAccessTime: Date, lastWriteTime: Date): IObjectBuilder;
```
где: 
  - `fileId` - новый идентификатор файла. Для генерации уникальных идентификаторов используйте метод `Guid.newGuid();`
  - `file` - добавляемый файл.
  - `creationTime` - дата создания файла.
  - `lastAccessTime` - дата последнего доступа к файлу.
  - `lastWriteTime` - дата последнего доступа на запись в файл.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.removeFile

Метод удаляет файл из текущего снимка файлов.

```ruby
removeFile(fileId: string): IObjectBuilder;
```
где: 
  - `fileId` - идентификатор файла.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setIsDeleted

Метод задаёт элементу состояние **удалено безвозвратно**.

```ruby
setIsDeleted(isDeleted: boolean): IObjectBuilder
```
где: 
  - `isDeleted` - значение флага.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setIsInRecycleBin

Метод задаёт элементу состояние **удалено в корзину**.

```ruby
setIsInRecycleBin(isInRecycleBin: boolean): IObjectBuilder
```
где: 
  - `isInRecycleBin` - значение флага.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.setIsFreezed

Метод задаёт элементу состояние заморозки.

```ruby
setIsFreezed(isFreezed: boolean): IObjectBuilder
```
где: 
  - `isFreezed` - значение флага.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setIsSecret

Метод делает элемент скрытым или общедоступным.

```ruby
setIsSecret(isSecret: boolean): IObjectBuilder
```
где: 
  - `isSecret` - значение флага.
  - `returns` - экземпляр **IObjectBuilder**.
  
##### IObjectBuilder.addAnnotationContainer

Метод создаёт или изменяет замечание.

```ruby
addAnnotationContainer(container: IAnnotationContainer, attrbutes: any): IObjectBuilder
```
где: 
  - `container` - структура, описывающая замечание.
  - `attrbutes` - дополнительная информация по замечанию.
  - `returns` - экземпляр **IObjectBuilder**.

##### IObjectBuilder.setSignatures

Метод создаёт модификатор запросов на подпись для указанного файла.

```ruby
setSignatures(fileId: string): ISignatureModifier;
```
где: 
  - `fileId` - идентифкатор файла, для которого надо добавить запрос на подпись.
  - `returns` - экземпляр **ISignatureModifier**.

<a name="ISignatureModifier"></a>
### Интерфейс ISignatureModifier

Интерфейс для создания и изменения запросов на подпись.
 
##### ISignatureModifier.create

Метод создает новый запрос на подпись для указанного файла.

```ruby
add(signatureRequestId: string): ISignatureBuilder;
```
где: 
  - `signatureRequestId` - новый идентифкатор запроса на подпись.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureModifier.edit

Метод редактирует запрос на подпись для указанного файла.

```ruby
edit(signatureRequest: ISignatureRequest): ISignatureBuilder;
```
где: 
  - `signatureRequest` - запроса на подпись для редактирования.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureModifier.remove

Метод удаляет запрос на подпись.

```ruby
remove(signatureRequestId: string): void;
```
где: 
  - `signatureRequest` - запроса на подпись для удаления.

<a name="ISignatureBuilder"></a>
### Интерфейс ISignatureBuilder

Интерфейс для изменения запроса на подпись.
 
##### ISignatureBuilder.withPositionId

Метод задает идентификатор должности пользователя, который должен будет подписать этот запрос на подпись.

```ruby
withPositionId(positionId: number): ISignatureBuilder;
```
где: 
  - `positionId` - идентифкатор должности.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureBuilder.withRole

Метод задает роль пользователя, под который пользователь должен будет подписать этот запрос на подпись.

```ruby
withRole(role: string): ISignatureBuilder;
```
где: 
  - `role` - роль пользователя.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureBuilder.withSign

Метод задает флаг, подписан ли запрос на подпись или нет.

```ruby
withSign(sign: string): ISignatureBuilder
```
где: 
  - `sign` - любая не пустая строка, если запрос подписан.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureBuilder.withRequestSigner

Метод задает имя пользователя запроса на подпись.

```ruby
withRequestSigner(requestSigner: string): ISignatureBuilder;
```
где: 
  - `requestSigner` - имя пользователя в запросе на подпись.
  - `returns` - экземпляр **ISignatureBuilder**.

##### ISignatureBuilder.withObjectId

Метод задает идентификатор связанного объекта с запросом на подпись. Например идентифкатор задания на согласование. 

```ruby
withObjectId(objectId: string): ISignatureBuilder;
```
где: 
  - `objectId` - идентификатор связанного объекта.
  - `returns` - экземпляр **ISignatureBuilder**.

<a name="IPersonalSettings"></a>
### Интерфейс IPersonalSettings

Интерфейс предназначен для работы с персональными и общими настройками пользователя.
Позволяет получать текущие значения настроек, подписываться на их изменения и изменять значения.
 
##### IPersonalSettings.getPersonalSettingValue

Получение значения персональной настройки для текущего пользователя по ключу.

```ruby
getPersonalSettingValue(key: string): Observable<string | undefined>;
```
где: 
  - `key` - ключ настройки, значение которой необходимо получить.
  - `returns` - Подписка, возвращающая строковое значение настройки для текущего пользователя или undefined, если настройка не установлена.

##### IPersonalSettings.subscribePersonalSettingValueChange

Подписка на значение персональной настройки по передаваемому ключу.

```ruby
subscribePersonalSettingValueChange(key: string): Observable<string | undefined>;
```
где: 
  - `key` - ключ персональной настройки, изменения которой необходимо отслеживать.
  - `returns` - Подписка, предоставляющая актуальное значение персональной настройки при изменении.

##### IPersonalSettings.getCommonSettingValue

Получение по ключу списка значений настройки для всех элементов организационной структуры, в которые входит текущий пользователь.

```ruby
getCommonSettingValue(key: string): Observable<string[]>;
```
где: 
  - `key` - ключ общей настройки.
  - `returns` - Подписка, возвращающая массив строковых значений настройки.

##### IPersonalSettings.subscribeCommonSettingValueChange

Подписка на изменения значения общей настройки по ключу.

```ruby
subscribeCommonSettingValueChange(key: string): Observable<string[]>;
```
где: 
  - `key` - ключ общей настройки.
  - `returns` - Подписка, предоставляющая актуальный массив строковых значений настройки при изменении.

##### IPersonalSettings.changeSettingValue

Изменение значения персональной настройки по ключу.

```ruby
changeSettingValue(key: string, value: string): Observable<void>;
```
где: 
  - `key` - ключ настройки, значение которой требуется изменить.
  - `value` - новое значение настройки.
  - `returns` - Observable, без возвращаемого значения.

<a name="IBimFeatures"></a>

### Интерфейс IBimFeatures

Интерфейс предназначен для работы с инструментами информационного моделирования моделей.
Позволяет получать экземпляры сервисов.
 
##### IBimFeatures.searchSetService

Получение экземпляра сервиса [IBimSearchSetService](#IBimSearchSetService) для работы с поисковыми наборами и выполнению поиска по BIM‑модели.

```ruby
get searchSetService(): IBimSearchSetService;
```
где: 
  - `returns` - Экземпляр сервиса [IBimSearchSetService](#IBimSearchSetService).

<a name="IBimSearchSetService"></a>

#### Интерфейс IBimSearchSetService

Интерфейс предназначен для работы с поисковыми наборами и выполнению поиска по BIM‑модели.

##### IBimSearchSetService.getFromModel

Получение списка поисковых наборов верхнего уровня, расположенных непосредственно в корневой (скрытой) папке модели. Не выполняет обход подкаталогов, возвращает только элементы первого уровня.

```ruby
getFromModel(id: string): Observable<IBimSearchSetData[]>;
```
где:  
  - `id` - идентификатор модели, для которой запрашиваются поисковые наборы верхнего уровня.
  - `returns` - Подписка, возвращающая массив `IBimSearchSetData`.

##### IBimSearchSetService.getRecursivelyFromModel

Получение полного списка всех элементов из корневой (скрытой) папки модели с рекурсивным обходом всех вложенных папок.

```ruby
getRecursivelyFromModel(id: string): Observable<IBimSearchSetData[]>;
```
где: 
  - `id` - идентификатор модели, для которой рекурсивно считываются все поисковые наборы.
  - `returns` - Подписка, возвращающая массив `IBimSearchSetData`.

##### IBimSearchSetService.getFromFolder

Получение списка поисковых наборов, находящихся непосредственно в указанной папке поисковых наборов. Вложенные папки не обходятся.

```ruby
getFromFolder(id: string): Observable<IBimSearchSetData[]>;
```
где:  
  - `id` - идентификатор папки поисковых наборов, из которой нужно получить элементы.
  - `returns` - Подписка, возвращающая массив `IBimSearchSetData`.

##### IBimSearchSetService.executeSearchSet

Выполнение сохранённого поискового набора по указанным частям модели.

```ruby
executeSearchSet(id: string, modelPartIds: string[]): Observable<IBimModelSearchResult[]>;
```
где: 
  - `id` - идентификатор поискового набора, который необходимо выполнить.
  - `modelPartIds` - массив идентификаторов частей модели, по которым будет выполняться поиск.
  - `returns` - Подписка, возвращающая массив `IBimModelSearchResult`.

##### IBimSearchSetService.executeStringQuery

Выполнение строкового поискового запроса по указанным частям модели.

```ruby
executeStringQuery(query: string, modelPartIds: string[]): Observable<IBimModelSearchResult[]>;
```
где: 
  - `query` - строковое выражение запроса.
  - `modelPartIds` - массив идентификаторов частей модели, по которым будет выполняться поиск.
  - `returns` - Подписка, возвращающая массив `IBimModelSearchResult`.

<a name="DocumentInterfaces"></a>

## 5. Интерфейсы контекста визуального представления документа

<a name="IRenderContextProvider"></a>

### Интерфейс IRenderContextProvider

Отдаёт экземпляр класса RenderContex. Получить интерфейс можно с помощью [инжектирования](#Injecting).

```ruby
getRenderContext(): RenderContext
```
где: 
  - `returns` - экземпляр RenderContext.


<a name="RenderContext"></a>

### RenderContext

Используйте этот тип контекста, чтобы узнать версию и элемент отображаемого документа. Получить объект можно через интерфейс **IRenderContextProvider**.

##### RenderContext.dataObject

Отдаёт элемент отображаемого документа.

```ruby
get dataObject(): IDataObject
```

##### RenderContext.selectedVersion

Получает версию отображаемого документа.

```ruby
get selectedVersion(): string
```

<a name="BIMInterfaces"></a>

## 6. Интерфейсы контекста визуального представления пространства модели

<a name="BimElementPanelContext"></a>

### Интерфейс BimElementPanelContext

Используйте этот тип контекста, для встраивания в левую панель (панель элемента) пространства "Информационного моделирования (BIM)" и чтобы узнать идентификатор модели и экземпляр `PilotWeb3D.Viewer3D` - обозревателя модели.

```ruby
get modelId(): string 
```
где: 
  - `returns` - GUID модели.

```ruby
get viewer(): PilotWeb3D.Viewer3D
```
где: 
  - `returns` - экземпляр обозревателя модели `PilotWeb3D.Viewer3D`.

<a name="BimRightPanelContext"></a>

### BimRightPanelContext

Используйте этот тип контекста, для встраивания в правую панель пространства "Информационного моделирования (BIM)" и чтобы узнать идентификатор модели и экземпляр `PilotWeb3D.Viewer3D` - обозревателя модели.

```ruby
get modelId(): string 
```
где: 
  - `returns` - GUID модели.

```ruby
get viewer(): PilotWeb3D.Viewer3D
```
где: 
  - `returns` - экземпляр обозревателя модели `PilotWeb3D.Viewer3D`.

<a name="AdditionalInterfaces"></a>

## 7. Дополнительные интерфейсы и утилиты

<a name="ExpectedError"></a>

### Ошибка ExpectedError

Класс ожидаемой ошибки. При ее обработке диалог ошибки отображается без дополнительных деталей (callstack, url), 
либо вообще не отображается.

##### isSilent

Определяет, отображается ли диалог ошибки.

```ruby
isSilent(): boolean = false
```