import os
import glob
import shutil
from pathlib import Path

# get current directory
current_dir = os.getcwd()
#print(current_dir)

root_nodes_folder = os.path.join(current_dir, 'node_modules')
if os.path.exists(root_nodes_folder) and os.path.isdir(root_nodes_folder):
  print(root_nodes_folder )
  shutil.rmtree( root_nodes_folder )

node_modules_folders_list = glob.glob(current_dir + '/**/node_modules', recursive=True) +  glob.glob(current_dir +'/**/.angular', recursive=True)
for folder in node_modules_folders_list:
  if os.path.exists(folder) and os.path.isdir(folder):
    print(folder)
    shutil.rmtree(folder)

package_lock_file = os.path.join(current_dir, "package-lock.json")
if os.path.exists(package_lock_file) : 
  os.remove(package_lock_file)