import { IPersonalSettings, SystemSettingsKeys } from "@pilotdev/pilot-web-sdk";
import { concat, map, Observable, takeUntil } from "rxjs";

export interface IAdvancementSettingsProvider {
  initialize(destroy: Observable<void>): Observable<void>;
  getSettings(): string[];
}

export class AdvancementSettingsProvider implements IAdvancementSettingsProvider {
  private _advancementSettings: string[] = [];

  constructor(private readonly _settings: IPersonalSettings) {}
  
  initialize(cancel: Observable<void>): Observable<void> {
    const initial$ = this._settings.getCommonSettingValue(SystemSettingsKeys.advancedSignatureFeatureKey);
    const updates$ = this._settings.subscribeCommonSettingValueChange(SystemSettingsKeys.advancedSignatureFeatureKey);

    return concat(initial$, updates$)
      .pipe(takeUntil(cancel))
      .pipe(map((commonSettings: string[]) => {
        this._advancementSettings.length = 0;

        commonSettings.forEach(setting => {
          if (!setting)
            return;

          const advancementSettings = setting.split('\n').map(x => x.trim());
          this._advancementSettings.push(...advancementSettings);
        });
    }));
  }

  getSettings(): string[] {
    return this._advancementSettings;
  }
}
