import { ICertificate, ISignatureVerificationResult, ISignatureRequest, IImportedSignatureVerificationResult } from "@pilotdev/pilot-web-sdk";

export interface IAdapter {
  init(): Promise<void>;
  sign(file: ArrayBuffer, certificate: ICertificate): Promise<string>;
  verify(file: ArrayBuffer, sign: ArrayBuffer, signatureRequset: ISignatureRequest): Promise<ISignatureVerificationResult>;
  verifyImportedSignature(file: ArrayBuffer, sign: ArrayBuffer): Promise<IImportedSignatureVerificationResult>;
  getCertificates(): Promise<ICertificate[]>;
}

export interface IErrorConverter {
  convertToError(error: unknown): Error | null;
}