import { CadesType } from "@pilotdev/pilot-web-sdk";

export class SignatureTypeConverter {
  static convert(signatureType: CadesType): number {
    switch (signatureType) {
      case CadesType.CadesBes:
        return cadesplugin.CADESCOM_CADES_BES;

      case CadesType.CadesT:
        return cadesplugin.CADESCOM_CADES_T;

      case CadesType.CadesXLongType1:
        return cadesplugin.CADESCOM_CADES_X_LONG_TYPE_1;

      default:
        return cadesplugin.CADESCOM_CADES_DEFAULT;
    }
  }
}