import { Component, Inject, Input, OnDestroy, OnInit } from '@angular/core';
import { MatDialogClose, MatDialogContent, MatDialogTitle } from "@angular/material/dialog";
import { MatIcon } from "@angular/material/icon";
import { MatIconButton } from "@angular/material/button";
import { Breakpoints } from "@angular/cdk/layout";
import { MatTooltip } from "@angular/material/tooltip";
import { IDataObject, ObjectsViewContext } from "@pilotdev/pilot-web-sdk";
import { ObjectInfoDisplayComponent } from "../object-info-display/object-info-display.component";
import {
  ObjectPropertiesComponent
} from "../object-properties/object-properties.component";
import { TranslateModule } from "@ngx-translate/core";
import { ASSETS_URL } from "../../extension/views";
import { Subscription } from "rxjs";
import { SelectedObjectService } from "../../services/selected-object.service";

@Component({
  selector: 'app-object-info',
  standalone: true,
  imports: [
    MatDialogClose,
    MatDialogTitle,
    MatIcon,
    MatIconButton,
    MatTooltip,
    MatIcon,
    MatDialogContent,
    ObjectInfoDisplayComponent,
    ObjectPropertiesComponent,
    TranslateModule,
  ],
  templateUrl: './object-info.component.html',
  styleUrl: './object-info.component.scss'
})
export class ObjectInfoComponent implements OnInit, OnDestroy {
  private selectedObjectSubscription!: Subscription;

  @Input() selectedObject!: IDataObject;

  constructor(
    @Inject('ObjectsViewContext') protected objectsViewContext: ObjectsViewContext,
    private selectedObjectService: SelectedObjectService
    ) {
  }

  ngOnInit(): void {
    this.selectedObjectSubscription = this.selectedObjectService.getSelectedObject()
      .subscribe(object => {
        if (object) {
          this.selectedObject = object;
        }
      });
  }

  ngOnDestroy(): void {
    if (this.selectedObjectSubscription) {
      this.selectedObjectSubscription.unsubscribe();
    }
  }

}
