import { Component, Inject, Input, OnInit } from '@angular/core';
import { IAccessRecord, IDataObject, IObjectsRepository } from "@pilotdev/pilot-web-sdk";
import {
  MatCell,
  MatCellDef,
  MatColumnDef,
  MatHeaderCell, MatHeaderCellDef,
  MatHeaderRow,
  MatHeaderRowDef, MatRow, MatRowDef, MatTable
} from "@angular/material/table";
import { DatePipe } from "@angular/common";

@Component({
  selector: 'app-access',
  standalone: true,
  imports: [
    MatCell,
    MatCellDef,
    MatColumnDef,
    MatHeaderCell,
    MatHeaderRow,
    MatHeaderRowDef,
    MatRow,
    MatRowDef,
    MatTable,
    MatHeaderCellDef,
    DatePipe
  ],
  templateUrl: './access.component.html',
  styleUrl: './access.component.scss'
})
export class AccessComponent implements OnInit {
  @Input() dataObject!: IDataObject;
  access: IAccessRecord[] = [];

  accessRecordsDatasource: IAccessRecord[] = [];
  displayedColumns: string[] = ["recordOwner", "orgUnitId", "inheritanceSource", "accessLevel", "isInheritable",
    "isInherited", "validThrough"];

  constructor(
    @Inject("IObjectsRepository") private _objectsRepository: IObjectsRepository ) {}


  ngOnInit(): void {
    const currentPerson = this._objectsRepository.getCurrentPerson();
    this._objectsRepository.getAccessRecords(this.dataObject.id, currentPerson.positions).subscribe(records => {
      this.accessRecordsDatasource = records;
    });

  }
}
