import { Inject, Injectable } from '@angular/core';
import { IFile } from "@pilotdev/pilot-web-sdk";

@Injectable({
  providedIn: 'root'
})
export class DownloadFilesService {

  constructor(
    @Inject('BASE_URL') private readonly _baseUrl: string,
  ) { }

  download(file: IFile): void {
    const url = this.getFileUrl(file.body.id, file.body.size);
    this.runDownloadFile(url, file.name);
  }

  downloadFileArchive(ids: string[], version?: string): void {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = this.getFileArchiveUrl();
    ids.forEach(id => {
      const input = document.createElement('input');
      input.type = 'hidden';
      input.name = 'ids'; //параметр должен совпадать с именем параметра в серверном апи
      input.value = id;
      form.appendChild(input);
    });

    if (version) {
      const input = document.createElement('input');
      input.type = 'hidden';
      input.name = 'version'; //параметр должен совпадать с именем параметра в серверном апи
      input.value = version;
      form.appendChild(input);
    }

    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
  }

  private runDownloadFile(url: string, name: string): void {
    const link = document.createElement('a');
    link.href = url;
    link.target = '_blank';
    link.download = name;
    link.click();
  }

  private getFileArchiveUrl(): string {
    return `${this._baseUrl}api/Files/GetFileArchive`;
  }

  private getFileUrl(id: string, size: number): string {
    return `${this._baseUrl}api/Files/GetFile?fileId=${id}&size=${size}`;
  }
}
