import { AfterViewInit, Component, Input, ViewChild } from '@angular/core';
import { IFile, ISignatureRequest } from "@pilotdev/pilot-web-sdk";
import { AsyncPipe, DatePipe, NgIf } from "@angular/common";
import {
  MatCell,
  MatCellDef,
  MatColumnDef,
  MatHeaderCell, MatHeaderCellDef,
  MatHeaderRow,
  MatHeaderRowDef, MatRow, MatRowDef, MatTable, MatTableDataSource
} from "@angular/material/table";
import { MatIcon } from "@angular/material/icon";
import { MatIconButton } from "@angular/material/button";
import { MatTooltip } from "@angular/material/tooltip";
import { MatPaginator } from "@angular/material/paginator";

@Component({
  selector: 'app-signatures-table',
  standalone: true,
  imports: [
    AsyncPipe,
    AsyncPipe,
    NgIf,
    DatePipe,
    MatCell,
    MatCellDef,
    MatColumnDef,
    MatHeaderCell,
    MatHeaderRow,
    MatHeaderRowDef,
    MatIcon,
    MatIconButton,
    MatRow,
    MatRowDef,
    MatTable,
    MatHeaderCellDef,
    MatTooltip,
    MatPaginator
  ],
  providers: [ ],
  templateUrl: './signatures-table.component.html',
  styleUrl: './signatures-table.component.scss'
})
export class SignaturesTableComponent implements AfterViewInit {
  private _file!: IFile;

  public dataSource!: MatTableDataSource<ISignatureRequest>;
  public displayedColumns: string[] = ["id", "positionId", "requestedSigner", "role", "signs"];

  public get selected(): IFile {
    return this._file;
  }
  @Input() set selected(file: IFile) {
    this._file = file;
    this.dataSource = new MatTableDataSource<ISignatureRequest>(file?.signatureRequests);
  }

  @ViewChild(MatPaginator) paginator!: MatPaginator;

  ngAfterViewInit() {
    this.dataSource.paginator = this.paginator;
  }
}
