﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using System.Reflection;

namespace PdfStamper.Resources;

internal class EmbeddedResources
{
    public static Stream? GetEmbeddedImage(string image)
    {
        var assembly = Assembly.GetExecutingAssembly();
        var resourceName = $"PdfStamper.Resources.Images.{image}";
        return assembly.GetManifestResourceStream(resourceName);
    }

    public static Stream? GetEmbeddedFont(string fontName)
    {
        var assembly = Assembly.GetExecutingAssembly();
        var resourceName = $"PdfStamper.Resources.Fonts.{fontName}";
        return assembly.GetManifestResourceStream(resourceName);
    }
}
