﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using PdfSharp.Fonts;

namespace PdfStamper.Resources;

internal class FontResolver : IFontResolver
{
    private const string RobotoRegularFontName = "Roboto#Regular";

    public byte[]? GetFont(string faceName)
    {
        if (faceName != RobotoRegularFontName)
            throw new NotSupportedException($"Font '{faceName}' is not supported.");

        using var fontStream = EmbeddedResources.GetEmbeddedFont("Roboto-Regular.ttf");
        if (fontStream == null)
            return null;

        using var ms = new MemoryStream();
        fontStream.CopyTo(ms);
        return ms.ToArray();
    }

    public FontResolverInfo? ResolveTypeface(string familyName, bool isBold, bool isItalic)
    {
        // можно добавить обработку Bold/Italic
        if (familyName.Equals(Constants.FONT_NAME, StringComparison.OrdinalIgnoreCase))
            return new FontResolverInfo(RobotoRegularFontName);

        return PlatformFontResolver.ResolveTypeface(familyName, isBold, isItalic);
    }
}
