﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/

using PdfSharp.Drawing;

namespace PdfStamper.Settings;

internal static class SettingsExtensions
{
    public static StampPosition CalculateFirstPosition(this SettingsModel settingsModel, XSize pageSize)
    {
        var unitOffsetX = XUnit.FromMillimeter(settingsModel.OffsetX);
        var unitOffsetY = XUnit.FromMillimeter(settingsModel.OffsetY);

        switch (settingsModel.Position)
        {
            case Position.LeftTop:
                return new StampPosition { X = unitOffsetX.Point, Y = unitOffsetY.Point };

            case Position.RightTop:
                return new StampPosition { X = pageSize.Width - unitOffsetX.Point, Y = unitOffsetY.Point };

            case Position.LeftBottom:
                return new StampPosition { X = unitOffsetX.Point, Y = pageSize.Height - unitOffsetY.Point };

            case Position.RightBottom:
                return new StampPosition { X = pageSize.Width - unitOffsetX.Point, Y = pageSize.Height - unitOffsetY.Point };
            default:
                throw new ArgumentOutOfRangeException(nameof(settingsModel.Position));
        }
    }
}
