﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Newtonsoft.Json;
using Pilot.WebServer.SDK;
using Pilot.WebServer.SDK.Data;

namespace PdfStamper.Settings;

internal class SettingsManager
{
    private readonly ISettingsStore _settingsStore;

    public SettingsManager(ISettingsStore settingsStore)
    {
        _settingsStore = settingsStore;
    }

    public SettingsModel GetStampSettings(IObject document)
    {
        var settings = _settingsStore.GetCommonSetting(Constants.STAMP_FEATURE_KEY).FirstOrDefault(x => x != null);
        var firstSettings = DeserializeSettings(settings).FirstOrDefault(x => x.TypeName == document.Type.Name);
        var settingsModel = firstSettings ?? SettingsModel.GetDefault();
        return settingsModel;
    }

    private IEnumerable<SettingsModel> DeserializeSettings(string? jsonString)
    {
        if (string.IsNullOrEmpty(jsonString))
            return Array.Empty<SettingsModel>();

        return JsonConvert.DeserializeObject<IEnumerable<SettingsModel>>(jsonString) ?? Array.Empty<SettingsModel>();
    }

    private string SerializeSettings(IEnumerable<SettingsModel> settings)
    {
        return JsonConvert.SerializeObject(settings, new JsonSerializerSettings { Formatting = Formatting.Indented });
    }
}
