﻿/*
  Copyright © 2025 ASCON-Design Systems LLC. All rights reserved.
  This sample is licensed under the MIT License.
*/
using Pilot.WebServer.SDK.Data;
using Pilot.WebServer.SDK;

namespace PdfStamper;

internal class Utils
{
    public static IFilesSnapshot? GetFilesSnapshot(PdfDocumentContext context)
    {
        var snapshots = new List<IFilesSnapshot>
        {
            context.Document.ActualFileSnapshot
        };
        snapshots.AddRange(context.Document.PreviousFileSnapshots);
        return snapshots.FirstOrDefault(snapshot => snapshot.Created.Ticks.Equals(context.Version.Ticks));
    }
}
