import { ICommand } from "../projectCloneWizard";
import { ObjectsViewContext, IDataObject } from "@pilotdev/pilot-web-sdk";  
import { PasteStructureCommand } from "./pasteStructureCommand";

export class CopyStructureCommand implements ICommand {

  constructor(private _pasteCommand: PasteStructureCommand) {}

  canCreate(context: ObjectsViewContext): boolean {
    if (context.contextObject == null)
      return false;

    if (context.selectedObjects.length != 1)
      return false; 

    return true;
  }

  isEnabled(context: ObjectsViewContext): boolean {
    return true;
  }

  invoke(structureRoot: IDataObject): void {
    this._pasteCommand.structureRoot = structureRoot;
  }
}