import { ObjectsViewContext, IDataObject, AccessLevel, ICommandBuilder, IProgressService, ProgressBarMode } from "@pilotdev/pilot-web-sdk";  
import { ICommand } from "../projectCloneWizard";

export class CreateStructureHereCommand implements ICommand {

  constructor(private _commandBuilderProvider: ICommandBuilder,
              private _progressService: IProgressService) {}

  canCreate(context: ObjectsViewContext): boolean {
    if (context.contextObject == null)
      return false;

    if (context.selectedObjects.length != 1)
      return false;

    return true;
  }

  isEnabled(context: ObjectsViewContext): boolean {

    if (!this.hasCreateAccess(context.contextObject, context.selectedObjects[0].type.id))
      return false; 
    
    return true;
  }

  invoke(structureRoot: string, destinaion: string): void {
    this._progressService.open(ProgressBarMode.Indeterminate);
    this._commandBuilderProvider.command('copyStructure')
                                .arg('structureRoot', structureRoot)
                                .arg('destinaion', destinaion)
                                .invoke()
                                .subscribe(() => this._progressService.close());
  };

  private hasCreateAccess(obj: IDataObject, rootTypeId: number): boolean {
    if (!obj.type.children.includes(rootTypeId))
      return false;

    return (obj.accessLevel & AccessLevel.Create) == AccessLevel.Create;
  }
}
