import { ObjectsViewContext, ICommandBuilder, IProgressService, IToolbarBuilder, IMenuBuilder } from "@pilotdev/pilot-web-sdk";  
import { CreateStructureHereCommand } from "./commands/createStructureHereCommand";
import { CopyStructureCommand } from "./commands/copyStructureCommand";
import { PasteStructureCommand } from "./commands/pasteStructureCommand";
import { COMMAND_COPY_STRUCTURE_HERE_NAME, COMMAND_COPY_STRUCTURE_NAME, COMMAND_PASTE_STRUCTURE_NAME } from "./constants";


export interface ICommand {
  canCreate(context: ObjectsViewContext): boolean;
  isEnabled(context: ObjectsViewContext): boolean;
}

export class ProjectCloneWizard {
  
  private static _instanse: ProjectCloneWizard;
  
  private _createStructureHere!: CreateStructureHereCommand;
  private _copyStructure!: CopyStructureCommand;
  private _pasteStructureHere!: PasteStructureCommand;
  private _initialized!: boolean;

  
  public static get instance(): ProjectCloneWizard {
    if (!ProjectCloneWizard._instanse)
      ProjectCloneWizard._instanse = new ProjectCloneWizard();
    return ProjectCloneWizard._instanse;
  }
  
  private constructor() {}

  public get createStructureHere(): CreateStructureHereCommand {
    return this._createStructureHere;
  }
  public get copyStructure(): CopyStructureCommand {
    return this._copyStructure;
  }
  public get pasteStructure(): PasteStructureCommand {
    return this._pasteStructureHere;
  }

  init(commandBuilderProvider: ICommandBuilder, progressService: IProgressService): void {
    if (this._initialized)
      return;

    this._createStructureHere = new CreateStructureHereCommand(commandBuilderProvider, progressService);
    const pasteStructureHere = new PasteStructureCommand(commandBuilderProvider, progressService);
    this._pasteStructureHere = pasteStructureHere;
    this._copyStructure = new CopyStructureCommand(pasteStructureHere);
    this._initialized = true;
  }

  invokeCommand(name: string, context: ObjectsViewContext): void {
    if (name == COMMAND_COPY_STRUCTURE_HERE_NAME)
      this.createStructureHere.invoke(context.selectedObjects[0].id, context.contextObject.id);

    if (name == COMMAND_COPY_STRUCTURE_NAME)
      this.copyStructure.invoke(context.selectedObjects[0]);

    if (name == COMMAND_PASTE_STRUCTURE_NAME)
      this.pasteStructure.invoke(context.selectedObjects[0].id);
  }

  needToAddSeparator(context: ObjectsViewContext): boolean {
    if (context.contextObject == null)
      return false; 

    return true;
  }
}

