/// <reference types="@pilotdev/pilot-web-2d" />

export class ClickListenerExtention extends PilotWeb2D.Extension {
  static readonly EXTENTION_NAME = "PilotWeb.ClickListenerExtention";
  private _remarkExt: any;

  constructor(_viewer: PilotWeb2D.GuiViewer2D) {
    super(_viewer);
  }
  
  override getName() {
    return ClickListenerExtention.EXTENTION_NAME;
  }

  override load() : boolean | Promise<boolean> {
    this._remarkExt = this._viewer.extensionsLoader.getExtension('PilotWeb2D.Remarks');

    if (!this._remarkExt) {
      return false;
    }

    this._remarkExt.activate();
    super.activate();
    return super.load();
  }

  override unload(): boolean {
    super.deactivate();
		return super.unload();
	}
  override onMouseDown(event: MouseEvent): void {
    if (event.button != 0)
    return;

    const page = this._remarkExt.getClickPage(event).pageNumber - 1;
    const point = this._remarkExt.getClickPoint(event);
    window.clickNotifier.notify(page, point);
  }
}

PilotWeb2D.theExtensionManager.registerExtensionType(ClickListenerExtention.EXTENTION_NAME, ClickListenerExtention);