const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require("copy-webpack-plugin");

module.exports = {
  mode: 'development',
  entry: {main: './src/index.ts',
          click_ext: './src/app/clickListenerExtention.ts'},
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
    ]},
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'annotation_page_changer',
    scriptType: 'text/javascript',
    filename: './[name].js',
    clean: true
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'annotation_page_changer',
      library: { type: 'var', name: 'annotation_page_changer' },
      filename: '[name].js',
      exposes: [
        {'IMenu<DocumentAnnotationsListContext>': './src/app/annotationPageChanger.ts'},
        {'IToolbar<DocumentAnnotationsListContext>': './src/app/annotationPageChanger.ts'}
      ],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    }),

    new CopyPlugin({
      patterns: [
        { from: "./src/assets/extensions.config.json", to: "./extensions.config.json" }
      ],
    }),
  ]
};
