﻿using Pilot.WebServer.SDK;
using System.ComponentModel.Composition;
using System.Numerics;
using System.Reflection;

namespace BackendCommandsSample
{
    [Export(typeof(ICommandHost))]
    public class BackendCommandsSample : ICommandHost
    {

        const string SAVE_FOLDER_NAME = "_saved";

        [Command]
        public string CommandImplementation(string str,
                                            long num,
                                            BigInteger bigInt,
                                            double dbl,
                                            bool boolean,
                                            Enum enumVal,
                                            Guid guid,
                                            DateTime date,
                                            string[] array1,
                                            string[][] array2,
                                            string[][][] array3,
                                            ComplexObject obj,
                                            ComplexObject[] objArray)
        {
            return "back";
        }



        [Command]
        public string[] FileCommandImplementation(Guid arg, IFileInfo[] files)
        {
            var result = new List<string>();
            foreach (var file in files)
            {
                string filePath = GetFilePath(file.Name);
                using (var stream = file.GetStream())
                using (var fileStream = File.Create(filePath))
                {
                    stream.CopyTo(fileStream);
                }
                result.Add(filePath);
            }
            return result.ToArray();
        }

        private static string GetFilePath(string fileName)
        {
            var dir = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
            var saveLocation = Path.Combine(dir, SAVE_FOLDER_NAME);
            if (!Directory.Exists(saveLocation))
                Directory.CreateDirectory(saveLocation);
            var filePath = Path.Combine(dir, SAVE_FOLDER_NAME, fileName);
            return filePath;
        }
    }
}
