﻿using Newtonsoft.Json;
using Pilot.WebServer.SDK;
using System.ComponentModel.Composition;

namespace BackendCommandsSample
{
    [Export(typeof(IDataConverter))]
    public class ComplexObjectConverter : IDataConverter
    {
        private readonly Type[] _supportedTypes;

        public ComplexObjectConverter()
        {
            _supportedTypes = new Type[] { typeof(ComplexObject) };
        }
        public Type[] SupportedTypes => _supportedTypes;

        public object Convert(object value)
        {
            return JsonConvert.DeserializeObject<ComplexObject>((string)value)!;
        }
    }


    [Export(typeof(IDataConverter))]
    public class DateConverter : IDataConverter
    {
        private readonly Type[] _supportedTypes;

        public DateConverter()
        {
            _supportedTypes = new Type[] { typeof(DateTime) };
        }
        public Type[] SupportedTypes => _supportedTypes;

        public object Convert(object value)
        {
            return DateTime.Parse(value.ToString()!);
        }
    }
}
