import { IMenu, IMenuBuilder, ObjectsViewContext, ICommandBuilderProvider, IProgressService, IInitializable, InjectionSource } from "@pilotdev/pilot-web-sdk";
import { SimpleCommand } from "./commands/simpleCommand";
import { FileCommand } from "./commands/fileCommand";

export class BackendCommandsSample extends IMenu<ObjectsViewContext> implements IInitializable {


  private _simpleCommand!: SimpleCommand;
  private _fileCommand!: FileCommand;
  private _progressService!: IProgressService;

  initialize(injectionSource: InjectionSource): void {
    this._progressService = injectionSource.progressService;
    this._simpleCommand = new SimpleCommand(injectionSource.commandBuilderProvider);
    this._fileCommand = new FileCommand(injectionSource.commandBuilderProvider);
  }

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {
    if (context.selectedObjects.length != 1)
      return;

      builder.addItem(SimpleCommand.MENU_NAME, 3).withHeader("invoke command on backend");
      builder.addItem(FileCommand.MENU_NAME, 4).withHeader("upload file to backend");
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {
    if (name == SimpleCommand.MENU_NAME)
      this._simpleCommand.invoke();

    if (name == FileCommand.MENU_NAME)
      this._fileCommand.invoke(this._progressService);
  }

}
