import { Guid, ICommandBuilderProvider } from "@pilotdev/pilot-web-sdk";
import { Enum, IComplexObject, ISimpleObject } from "../data";

export class SimpleCommand {

  public static readonly MENU_NAME = "simpleCommand";
  private static readonly BACKEND_NAME = "CommandImplementation";

  constructor(private _commandBuilderProvider: ICommandBuilderProvider) {}

  public invoke(): void {

    const builder = this._commandBuilderProvider.newCommandBuilder();
    const objs = this.createObjects();
    builder.command(SimpleCommand.BACKEND_NAME)
           .arg("str", "val")
           .arg("num", 100)
           .arg("bigInt", 9007199254323235545343232740991n.toString())
           .arg("dbl", 100.25)
           .arg("boolean", true)
           .arg("enumVal", Enum.Four)
           .arg("guid", Guid.newGuid())
           .arg("date", new Date().toISOString())
           .arg("array1", ['One', 'Two', 'Three'])
           .arg("array2", [['One', 'Two'], ['Three']])
           .arg("array3", [[['One', 'Two'], ['Three', 'Four']], [['Five'], ['Six']]])
           .arg("obj", JSON.stringify(objs[0]))
           .arg("objArray", objs.map(x => JSON.stringify(x)))
           .invoke<string>().subscribe(x => {
             alert(`responce: ${x}`);
           });
  }

  private createObjects(): IComplexObject[] {

    const obj1 = { 
      simpleObject: {
        name: "name1",
        value: 1
      } as ISimpleObject
    } as IComplexObject;
   
    const obj2 = { 
      simpleObject: {
        name: "name2",
        value: 2
      } as ISimpleObject
    } as IComplexObject;

    return [obj1, obj2];
  }
}