const ModuleFederationPlugin = require('webpack/lib/container/ModuleFederationPlugin');
const CopyPlugin = require("copy-webpack-plugin");

module.exports = {
  mode: 'development',
  entry: {main: './src/index.ts'},
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: 'ts-loader',
        exclude: /node_modules/,
      },
    ]},
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: 'auto',
    uniqueName: 'backend_commands_sample',
    scriptType: 'text/javascript',
    filename: './[name].js',
    clean: true
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false
  },
  plugins: [
    new ModuleFederationPlugin({
      name: 'backend_commands_sample',
      library: { type: 'var', name: 'backend_commands_sample' },
      filename: '[name].js',
      exposes: [{'IMenu<ObjectsViewContext>': './src/app/backendCommandsSample.ts'}],
      shared: {
        '@pilotdev/pilot-web-sdk': {
          singleton: true,
        }
      }
    }),

    new CopyPlugin({
      patterns: [
        { from: "./src/assets/extensions.config.json", to: "./extensions.config.json" }
      ],
    }),
  ]
};
