/**
 * Copyright (c) 2024 ASCON-Design Systems LLC. All rights reserved.
 * This sample is licensed under the MIT License.
 */

import { Injectable } from '@angular/core';
import { ITabs, ITabsBuilder, BimRightPanelContext } from '@pilotdev/pilot-web-sdk';
import { RightPanelTabId } from '../ids';

const searchIcon =
  'PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHdpZHRoPSIyNCIgaGVpZ2h0PSIyNCIgdmlld0JveD0iMCAwIDI0IDI0IiBmaWxsPSJub25lIiBzdHJva2U9ImN1cnJlbnRDb2xvciIgc3Ryb2tlLXdpZHRoPSIyIiBzdHJva2UtbGluZWNhcD0icm91bmQiIHN0cm9rZS1saW5lam9pbj0icm91bmQiIGNsYXNzPSJsdWNpZGUgbHVjaWRlLWZvbGRlci1zZWFyY2gyLWljb24gbHVjaWRlLWZvbGRlci1zZWFyY2gtMiI+PGNpcmNsZSBjeD0iMTEuNSIgY3k9IjEyLjUiIHI9IjIuNSIvPjxwYXRoIGQ9Ik0yMCAyMGEyIDIgMCAwIDAgMi0yVjhhMiAyIDAgMCAwLTItMmgtNy45YTIgMiAwIDAgMS0xLjY5LS45TDkuNiAzLjlBMiAyIDAgMCAwIDcuOTMgM0g0YTIgMiAwIDAgMC0yIDJ2MTNhMiAyIDAgMCAwIDIgMloiLz48cGF0aCBkPSJNMTMuMyAxNC4zIDE1IDE2Ii8+PC9zdmc+';

@Injectable({providedIn: "root"})
export class BimRightPanelTabs implements ITabs<BimRightPanelContext> {
  build(builder: ITabsBuilder): void {
    builder
      .addItem(RightPanelTabId, 1)
      .withTitle('Right Panel Sample')
      .withIcon('bim-document-sample-search-tab', searchIcon)
      .withViewId(RightPanelTabId);
  }
}
