import {
  AttributeType,
  AttributeValueChangedEventArgs,
  IAttribute,
  IAttributeModifier,
  IObjectCardHandler,
  ObjectCardContext,
} from "@pilotdev/pilot-web-sdk";

export class ObjectCardHandlerSample implements IObjectCardHandler {
  handle(modifier: IAttributeModifier, context: ObjectCardContext): void {
    const isObjectModification = context.editedObject != null;
    if (isObjectModification || context.isReadOnly)
      return;

    const targetStrAttr = context.displayAttributes.find((a) => a.type == AttributeType.String);
    if (targetStrAttr == null)
      return;

    modifier.setValue(targetStrAttr.name, "plugin works");

    const targetAttr = context.displayAttributes.find((a) => a.type == AttributeType.OrgUnit);
    if (targetAttr == null)
      return;

    const valueToSet = [ 5 ];

    modifier.setValue(targetAttr.name, valueToSet);

    return;
  }

  onValueChanged(
    sender: IAttribute,
    args: AttributeValueChangedEventArgs,
    modifier: IAttributeModifier
  ): void {
    let currentAttributeValues = "";
    args.context.displayAttributes.forEach((dispAttr) => {
      if (args.context.attributesValues.has(dispAttr.name)) {
        currentAttributeValues +=
          dispAttr.name === sender.name
            ? `> ${dispAttr.name}: ${args.newValue}\n`
            : `• ${dispAttr.name}: ${args.context.attributesValues.get(
                dispAttr.name
              )}\n`;
      }
    });

    console.log(currentAttributeValues);

    if (args.context.type.name === "document" && sender.name === "sheet_number") {
      const objectStatus = args.context.editedObject == null ? "New" : "Existing";
      const newNameAttrValue = `Sheet №${args.newValue}; ${objectStatus} object`;

      modifier.setValue("name", newNameAttrValue);
      return;
    }

    return;
  }
}
