const ModuleFederationPlugin = require("webpack/lib/container/ModuleFederationPlugin");
const CopyPlugin = require("copy-webpack-plugin");

module.exports = {
  mode: "development",
  entry: {
    main: "./src/index.ts",
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: "ts-loader",
        exclude: /node_modules/,
      },
    ],
  },
  resolve: {
    extensions: [".tsx", ".ts", ".jsx", ".js", ".json"],
  },
  output: {
    publicPath: "auto",
    uniqueName: "object_card_handler_sample",
    scriptType: "text/javascript",
    filename: "./[name].js",
    clean: true,
  },
  optimization: {
    // fix a temporary bug
    runtimeChunk: false,
  },
  plugins: [
    new ModuleFederationPlugin({
      name: "object_card_handler_sample",
      library: { type: "var", name: "object_card_handler_sample" },
      filename: "[name].js",
      exposes: [{ IObjectCardHandler: "./src/extension/index.ts" }],
      shared: {
        "@pilotdev/pilot-web-sdk": {
          singleton: true,
        },
      },
    }),

    new CopyPlugin({
      patterns: [
        {
          from: "./src/assets/extensions.config.json",
          to: "./extensions.config.json",
        },
      ],
    }),
  ],
  devServer: {
    port: 4300,
    allowedHosts: "auto",
    headers: {
      "Access-Control-Allow-Origin": "*",
    },
  },
};
