﻿using Pilot.WebServer.SDK.Data;
using Pilot.WebServer.SDK.Search;

namespace SearchSample;

public class SearchResultObserver : IObserver<ISearchResult>
{
    private readonly IPerson _changedPerson;

    public SearchResultObserver(IPerson changedPerson)
    {
        _changedPerson = changedPerson;
    }

    public void OnNext(ISearchResult value)
    {
        Console.WriteLine($"{_changedPerson.DisplayName} has created {value.Total} objects");
    }

    public void OnCompleted()
    {
    }

    public void OnError(Exception error)
    {
    }
}