﻿using System.ComponentModel.Composition;
using Pilot.WebServer.SDK;

namespace SettingsSupport;

[Export(typeof(ICommandHost))]
public class SettingsSupportSample : ICommandHost
{
    private readonly ISettingsStore _manager;

    [ImportingConstructor]
    public SettingsSupportSample(ISettingsStore manager, IRepositoryEvents events)
    {
        _manager = manager;
        events.SubscribeSettings().Subscribe(new SettingsEventsObserver());
    }

    [Command]
    public void SetOptionValue(string key, string val)
    {
        _manager.ChangePersonalSetting(key, val);
    }

    [Command]
    public string GetOptionValue(string key)
    {
        return _manager.GetPersonalSetting(key);
    }

    private class SettingsEventsObserver : IObserver<string>
    {
        public void OnCompleted() { }
        public void OnError(Exception error) { }

        public void OnNext(string value)
        {
            Console.WriteLine($"[SettingsSupportSample] New value of setting key {value} detected");
        }
    }
}