import { IMenu, IMenuBuilder, IToolbar, ObjectsViewContext, IToolbarBuilder } from '@pilotdev/pilot-web-sdk';
import { Constants } from './constants';

export class ObjectsToolbarExtensionSample extends IToolbar<ObjectsViewContext> {

  build(builder: IToolbarBuilder, context: ObjectsViewContext): void {

    var count = builder.count;
    builder.addSeparator(count);
    count++;

    builder.addButtonItem(Constants.BUTTON_NAME, count)
      .withHeader('Count selected items')
      .withIsEnabled(context.selectedObjects?.length > 0)
      .withIcon(Constants.BUTTON_ICON_NAME, Constants.BUTTON_ICON)
      .withHint('Count selected items');

    // Replace toolbar item and disable it
    if (context.selectedObjects?.length == 1)
      builder.replaceButtonItem('miShowObjectCard').withIsEnabled(false);
  }

  onToolbarItemClick(name: string, context: ObjectsViewContext): void {
    if (name == Constants.BUTTON_NAME) {
      var selected = context.selectedObjects?.length;
      alert('The number of selected elements: ' + selected);
    }
  }
}

export class ObjectsContextMenuExtensionSample extends IMenu<ObjectsViewContext> {

  build(builder: IMenuBuilder, context: ObjectsViewContext): void {

    // Replace menu item and disable it
    if (context.selectedObjects?.length == 1)
      builder.replaceItem('miShowObjectCard').withIsEnabled(false);
  }

  onMenuItemClick(name: string, context: ObjectsViewContext): void {

  }  
}